/*
 * Decompiled with CFR 0.152.
 */
package jwsu.viewbranch;

import com.sun.j3d.utils.behaviors.mouse.MouseRotate;
import com.sun.j3d.utils.behaviors.mouse.MouseTranslate;
import com.sun.j3d.utils.behaviors.mouse.MouseZoom;
import java.awt.AWTEvent;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.vecmath.Point3d;

class MyMouseNavigate {
    private MouseRotate myMouseRotate;
    private MouseTranslate myMouseTranslate;
    private MouseZoom myMouseZoom;

    public MyMouseNavigate(TransformGroup transformGroup, BranchGroup branchGroup) {
        BoundingSphere boundingSphere = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.MAX_VALUE);
        TransformGroup transformGroup2 = transformGroup;
        this.myMouseRotate = new MouseRotate(2);
        this.myMouseRotate.setTransformGroup(transformGroup);
        this.myMouseRotate.setSchedulingBounds((Bounds)boundingSphere);
        branchGroup.addChild((Node)this.myMouseRotate);
        this.myMouseTranslate = new MouseTranslate(2);
        this.myMouseTranslate.setTransformGroup(transformGroup);
        this.myMouseTranslate.setSchedulingBounds((Bounds)boundingSphere);
        branchGroup.addChild((Node)this.myMouseTranslate);
        this.myMouseZoom = new MouseZoom(2);
        this.myMouseZoom.setTransformGroup(transformGroup);
        this.myMouseZoom.setSchedulingBounds((Bounds)boundingSphere);
        branchGroup.addChild((Node)this.myMouseZoom);
        SwitchBehavior switchBehavior = new SwitchBehavior(branchGroup, this);
        branchGroup.addChild((Node)switchBehavior);
    }

    public void EnableMyMouseNavigate() {
        this.myMouseRotate.setEnable(true);
        this.myMouseTranslate.setEnable(true);
        this.myMouseZoom.setEnable(true);
    }

    public void DisableMyMouseNavigate() {
        this.myMouseRotate.setEnable(false);
        this.myMouseTranslate.setEnable(false);
        this.myMouseZoom.setEnable(false);
    }

    public boolean IsMyMouseNavigateEnabled() {
        return this.myMouseRotate.getEnable() && this.myMouseTranslate.getEnable() && this.myMouseZoom.getEnable();
    }

    class SwitchBehavior
    extends Behavior {
        private MyMouseNavigate m;

        public SwitchBehavior(BranchGroup branchGroup, MyMouseNavigate myMouseNavigate2) {
            this.m = myMouseNavigate2;
            BoundingSphere boundingSphere = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.MAX_VALUE);
            this.setSchedulingBounds((Bounds)boundingSphere);
        }

        public void initialize() {
            this.wakeupOn((WakeupCondition)new WakeupOnAWTEvent(400));
        }

        public void processStimulus(Enumeration enumeration) {
            while (enumeration.hasMoreElements()) {
                WakeupCriterion wakeupCriterion = (WakeupCriterion)enumeration.nextElement();
                if (!(wakeupCriterion instanceof WakeupOnAWTEvent)) continue;
                AWTEvent[] aWTEventArray = ((WakeupOnAWTEvent)wakeupCriterion).getAWTEvent();
                int n = 0;
                while (n < aWTEventArray.length) {
                    int n2 = aWTEventArray[n].getID();
                    char c = ((KeyEvent)aWTEventArray[n]).getKeyChar();
                    if (n2 == 400 && c == 's') {
                        if (this.m.IsMyMouseNavigateEnabled()) {
                            this.m.DisableMyMouseNavigate();
                        } else {
                            this.m.EnableMyMouseNavigate();
                        }
                    }
                    ++n;
                }
            }
            this.wakeupOn((WakeupCondition)new WakeupOnAWTEvent(400));
        }
    }
}

