/*
 * Decompiled with CFR 0.152.
 */
package jwsu.viewbranch;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import javax.media.j3d.InputDevice;
import javax.media.j3d.Sensor;
import javax.media.j3d.SensorRead;
import javax.media.j3d.Transform3D;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

class InputDeviceTty
implements InputDevice {
    private Sensor[] sensors;
    private final int npol;
    private BufferedReader bufReader;
    private Vector3d pos = new Vector3d();
    private Point3d angle = new Point3d();
    private Transform3D trans = new Transform3D();
    private Transform3D temp = new Transform3D();

    public static void main(String[] stringArray) {
        InputDeviceTty inputDeviceTty = new InputDeviceTty(3);
        int n = 0;
        while (n < 100) {
            inputDeviceTty.pollAndProcessInput();
            int n2 = 0;
            while (n2 < 3) {
                Transform3D transform3D = new Transform3D();
                inputDeviceTty.getSensor(n2).getCurrentSensorRead().get(transform3D);
                System.out.println("SensorRead trans " + n2 + " = " + transform3D);
                Vector3d vector3d = new Vector3d();
                Matrix3d matrix3d = new Matrix3d();
                transform3D.get(matrix3d, vector3d);
                ++n2;
            }
            ++n;
        }
    }

    public InputDeviceTty(int n) {
        this.npol = n;
        this.sensors = new Sensor[n];
        int n2 = 0;
        while (n2 < n) {
            this.sensors[n2] = new Sensor((InputDevice)this);
            ++n2;
        }
        this.bufReader = new BufferedReader(new InputStreamReader(System.in));
    }

    public void close() {
    }

    public Sensor getSensor(int n) {
        return this.sensors[n];
    }

    public int getSensorCount() {
        return this.npol;
    }

    public boolean initialize() {
        return true;
    }

    public void processStreamInput() {
    }

    public void setNominalPositionAndOrientation() {
    }

    public int getProcessingMode() {
        return 3;
    }

    public void setProcessingMode(int n) {
    }

    public void pollAndProcessInput() {
        int n = 0;
        while (n < this.npol) {
            String string = null;
            System.out.println("Pol " + n + ": Enter 3 or 6 numbers or nothing:");
            try {
                string = this.bufReader.readLine();
            }
            catch (IOException iOException) {
                System.err.println("IO Error: " + iOException);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (stringTokenizer.countTokens() != 6 && stringTokenizer.countTokens() != 3 && stringTokenizer.countTokens() != 0) {
                System.err.println("Expected 3 or 6 numbers or nothing, ignoring: " + string);
                return;
            }
            this.pos.set(0.0, 0.0, 0.0);
            if (stringTokenizer.countTokens() > 0) {
                this.pos.x = Double.parseDouble(stringTokenizer.nextToken().trim());
                this.pos.y = Double.parseDouble(stringTokenizer.nextToken().trim());
                this.pos.z = Double.parseDouble(stringTokenizer.nextToken().trim());
            }
            this.angle.set(0.0, 0.0, 0.0);
            if (stringTokenizer.countTokens() > 0) {
                this.angle.x = Double.parseDouble(stringTokenizer.nextToken().trim());
                this.angle.y = Double.parseDouble(stringTokenizer.nextToken().trim());
                this.angle.z = Double.parseDouble(stringTokenizer.nextToken().trim());
            }
            this.pos.scale(0.0254);
            this.trans.set(this.pos);
            this.temp.rotY(-Math.toRadians(this.angle.x));
            this.trans.mul(this.temp);
            this.temp.rotX(Math.toRadians(this.angle.y));
            this.trans.mul(this.temp);
            this.temp.rotZ(-Math.toRadians(this.angle.z));
            this.trans.mul(this.temp);
            SensorRead sensorRead = new SensorRead();
            sensorRead.set(this.trans);
            this.sensors[n].setNextSensorRead(sensorRead);
            ++n;
        }
    }
}

