/*
 * Decompiled with CFR 0.152.
 */
package jwsu.viewbranch;

import java.io.IOException;
import java.io.OutputStream;
import javax.media.j3d.SensorRead;
import javax.media.j3d.Transform3D;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import jwsu.viewbranch.InputDeviceEye;

class InputDevicePolhemus
extends InputDeviceEye {
    private double[] RAW_Y_ROTS;
    private final int npol;
    private boolean dofast;
    protected OutputStream mOutputStream;
    private Vector3d pos;
    private Point3d angle;
    private Transform3D trans;
    private Transform3D temp;
    private int[] dataRec;
    private int[] Fast;
    private int StartByte;

    public double getRaw_Y_Rotation() {
        return this.RAW_Y_ROTS[0];
    }

    public double getRaw_Y_Rotation(int n) {
        if (n < 0 || n > 3) {
            System.err.println("we only store rotations for 4 sensors 0 .. 3");
            System.exit(-1);
        }
        return this.RAW_Y_ROTS[n];
    }

    public static void main(String[] stringArray) {
        int n = 4;
        InputDevicePolhemus inputDevicePolhemus = new InputDevicePolhemus(n, 38400, "/dev/term/b");
        int n2 = 0;
        while (n2 < 10000) {
            inputDevicePolhemus.pollAndProcessInput();
            int n3 = 0;
            while (n3 < n) {
                Transform3D transform3D = new Transform3D();
                inputDevicePolhemus.getSensor(n3).getCurrentSensorRead().get(transform3D);
                Vector3d vector3d = new Vector3d();
                Matrix3d matrix3d = new Matrix3d();
                transform3D.get(matrix3d, vector3d);
                System.out.println("SensorRead v " + n3 + " = " + (String.valueOf(vector3d.x) + "     ").substring(0, 5) + " " + (String.valueOf(vector3d.y) + "     ").substring(0, 5) + " " + (String.valueOf(vector3d.z) + "     ").substring(0, 5));
                ++n3;
            }
            ++n2;
        }
    }

    public InputDevicePolhemus(int n, int n2, String string, boolean bl) {
        this(n, n2, string);
        this.dofast = bl;
    }

    public InputDevicePolhemus(int n, int n2, String string) {
        block8: {
            super(n, n2, string);
            this.RAW_Y_ROTS = new double[4];
            this.dofast = false;
            this.mOutputStream = null;
            this.pos = new Vector3d();
            this.angle = new Point3d();
            this.trans = new Transform3D();
            this.temp = new Transform3D();
            this.dataRec = new int[30];
            this.Fast = new int[4];
            this.StartByte = 0;
            this.npol = n;
            try {
                if (this.device.startsWith("<")) {
                    System.err.println("This class does NOT support input from file!");
                    System.exit(-1);
                } else {
                    this.mOutputStream = this.serialPort.getOutputStream();
                    int n3 = 1;
                    while (n3 <= n) {
                        String string2 = "O" + n3 + ",2,0,4,1\r";
                        this.mOutputStream.write(string2.getBytes(), 0, string2.length());
                        ++n3;
                    }
                    this.mOutputStream.write("f".getBytes(), 0, 1);
                    this.mOutputStream.write("u".getBytes(), 0, 1);
                    this.mOutputStream.flush();
                    this.mOutputStream.write("C".getBytes(), 0, 1);
                }
            }
            catch (Exception exception) {
                System.err.println("Error opening stream on device: " + exception);
                try {
                    if (this.inputStream != null) {
                        this.inputStream.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                if (this.serialPort == null) break block8;
                this.serialPort.close();
            }
        }
    }

    public void pollAndProcessInput() {
        int n = 0;
        int n2 = 0;
        while (n2 < 2) {
            if (this.neyebuf + 1000 > 200000) {
                System.err.println("Error: tracker input buffer overflow, discarding buffer");
                this.neyebuf = 0;
                this.StartByte = 0;
            }
            try {
                n = this.inputStream.read(this.eyebuf, this.neyebuf, 1000);
            }
            catch (IOException iOException) {
                System.err.println("Error reading tracker: " + iOException);
            }
            if (n <= 0) break;
            this.neyebuf += n;
            ++n2;
        }
        int n3 = 0;
        while (n3 < 4) {
            this.Fast[n3] = 0;
            ++n3;
        }
        if (this.dofast && this.neyebuf - this.StartByte > this.npol * 30 * 3) {
            this.StartByte = this.neyebuf - this.npol * 30 * 3;
        }
        int n4 = this.StartByte;
        while (n4 < this.neyebuf) {
            if (this.neyebuf - 30 >= 0 && n4 <= this.neyebuf - 30 && this.eyebuf[n4 + 28] == 13 && this.eyebuf[n4 + 29] == 10) {
                int n5;
                int n6;
                int n7 = n4;
                int n8 = 0;
                while (n7 <= n4 + 27) {
                    this.dataRec[n8] = 0xFF & this.eyebuf[n7];
                    ++n7;
                    ++n8;
                }
                int n9 = (this.dataRec[0] ^ this.dataRec[1]) - 1;
                if (n9 >= 0 && n9 < this.npol) {
                    int n10 = n9;
                    this.Fast[n10] = this.Fast[n10] + 1;
                    n6 = 0;
                    int n11 = 0;
                    int n12 = 0;
                    int n13 = 0;
                    int n14 = 0;
                    n5 = 0;
                    while (n5 < 3) {
                        n6 = this.dataRec[3 + 4 * n5];
                        n11 = this.dataRec[4 + 4 * n5];
                        n12 = this.dataRec[5 + 4 * n5];
                        n13 = this.dataRec[6 + 4 * n5];
                        n14 = n13 << 24 | n12 << 16 | n11 << 8 | n6;
                        if (n5 == 0) {
                            this.pos.z = -Float.intBitsToFloat(n14);
                        } else if (n5 == 1) {
                            this.pos.x = Float.intBitsToFloat(n14);
                        } else if (n5 == 2) {
                            this.pos.y = -Float.intBitsToFloat(n14);
                        }
                        ++n5;
                    }
                    n5 = 0;
                    while (n5 < 3) {
                        n6 = this.dataRec[16 + 4 * n5];
                        n11 = this.dataRec[17 + 4 * n5];
                        n12 = this.dataRec[18 + 4 * n5];
                        n13 = this.dataRec[19 + 4 * n5];
                        n14 = n13 << 24 | n12 << 16 | n11 << 8 | n6;
                        if (n5 == 0) {
                            this.angle.x = Float.intBitsToFloat(n14);
                        } else if (n5 == 1) {
                            this.angle.y = Float.intBitsToFloat(n14);
                        } else if (n5 == 2) {
                            this.angle.z = Float.intBitsToFloat(n14);
                        }
                        ++n5;
                    }
                    this.trans.set(this.pos);
                    this.temp.rotY(-Math.toRadians(this.angle.x));
                    this.trans.mul(this.temp);
                    this.RAW_Y_ROTS[n9] = -this.angle.x;
                    this.temp.rotX(Math.toRadians(this.angle.y));
                    this.trans.mul(this.temp);
                    this.temp.rotZ(-Math.toRadians(this.angle.z));
                    this.trans.mul(this.temp);
                    SensorRead sensorRead = new SensorRead();
                    sensorRead.set(this.trans);
                    this.sensors[n9].setNextSensorRead(sensorRead);
                }
                n5 = 0;
                n6 = 0;
                while (n6 < this.npol) {
                    if (this.Fast[n6] != 0) {
                        ++n5;
                    }
                    ++n6;
                }
                if (n5 == this.npol) {
                    this.StartByte = n4 + 30;
                    return;
                }
            }
            ++n4;
        }
        this.neyebuf = 0;
        this.StartByte = 0;
    }
}

