/*
 * Decompiled with CFR 0.152.
 */
package jwsu.viewbranch;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.comm.CommPortIdentifier;
import javax.comm.SerialPort;
import javax.media.j3d.InputDevice;
import javax.media.j3d.Sensor;
import jwsu.viewbranch.PinchEvent;
import jwsu.viewbranch.PinchListener;
import jwsu.viewbranch.TestListener;

public class InputDevicePinch
implements InputDevice {
    public static final int R_PINKIE = 0;
    public static final int R_RING = 1;
    public static final int R_MIDDLE = 2;
    public static final int R_INDEX = 3;
    public static final int R_THUMB = 4;
    public static final int L_PINKIE = 5;
    public static final int L_RING = 6;
    public static final int L_MIDDLE = 7;
    public static final int L_INDEX = 8;
    public static final int L_THUMB = 9;
    private String device;
    private SerialPort serialPort;
    private InputStream inputStream;
    private PinchListener listener;
    private final int NREAD = 6;
    private static final int NBUF = 1000;
    private byte[] buf;
    private int iread;
    int idisp;
    private static int NFINGERS = 10;
    private static final int OFF = 1;
    private static final int WASON = 2;
    private static final int ISON = 3;
    private int[][] status;
    private static final byte STARTBYTE = -128;
    private static final byte STARTTBYTE = -127;
    private static final byte STARTXBYTE = -126;
    private static final byte ENDBYTE = -113;

    public static void main(String[] stringArray) {
        TestListener testListener = new TestListener();
        InputDevicePinch inputDevicePinch = new InputDevicePinch(testListener, 38400, "/dev/term/b");
        int n = 0;
        while (n < 100) {
            inputDevicePinch.pollAndProcessInput();
            ++n;
        }
    }

    public InputDevicePinch(PinchListener pinchListener, int n, String string) {
        block9: {
            this.device = "/dev/term/a";
            this.serialPort = null;
            this.inputStream = null;
            this.NREAD = 6;
            this.buf = new byte[1000];
            this.iread = 0;
            this.idisp = 0;
            this.status = new int[NFINGERS][];
            this.listener = pinchListener;
            this.device = string;
            int n2 = 0;
            while (n2 < NFINGERS) {
                this.status[n2] = new int[NFINGERS];
                int n3 = n2 + 1;
                while (n3 < NFINGERS) {
                    this.status[n2][n3] = 1;
                    ++n3;
                }
                ++n2;
            }
            try {
                if (this.device.startsWith("<")) {
                    this.inputStream = new FileInputStream(new File(this.device.substring(1)));
                } else {
                    CommPortIdentifier commPortIdentifier = CommPortIdentifier.getPortIdentifier((String)this.device);
                    this.serialPort = (SerialPort)commPortIdentifier.open("ISCAN", 5000);
                    this.serialPort.setSerialPortParams(n, 8, 1, 0);
                    this.serialPort.setFlowControlMode(0);
                    this.serialPort.enableReceiveThreshold(1);
                    this.serialPort.enableReceiveTimeout(30);
                    this.inputStream = this.serialPort.getInputStream();
                }
            }
            catch (Exception exception) {
                System.err.println("Error opening device: " + exception);
                try {
                    if (this.inputStream != null) {
                        this.inputStream.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                if (this.serialPort == null) break block9;
                this.serialPort.close();
            }
        }
    }

    public void close() {
    }

    public Sensor getSensor(int n) {
        return null;
    }

    public int getSensorCount() {
        return 0;
    }

    public boolean initialize() {
        return true;
    }

    public void processStreamInput() {
    }

    public void setNominalPositionAndOrientation() {
    }

    public int getProcessingMode() {
        return 3;
    }

    public void setProcessingMode(int n) {
    }

    public void pollAndProcessInput() {
        int n = 0;
        do {
            if (this.iread + 6 > 1000) {
                System.err.println("Error: Pinch glove input buffer overflow, discarding buffer");
                this.idisp = 0;
                this.iread = 0;
            }
            try {
                n = this.inputStream.read(this.buf, this.iread, 6);
                this.iread += n;
            }
            catch (IOException iOException) {
                System.err.println("Error reading eye tracker: " + iOException);
            }
        } while (n != 0);
        while (this.idisp < this.iread) {
            int n2;
            int n3;
            int n4;
            int n5;
            ++this.idisp;
            while (this.buf[this.idisp] != -113 && this.idisp < this.iread) {
                ++this.idisp;
            }
            if (this.idisp == this.iread) {
                this.idisp = n5;
                break;
            }
            ++this.idisp;
            if (this.buf[n5] != -127 && this.buf[n5] != -128) continue;
            int n6 = 0;
            while (n6 < NFINGERS) {
                n4 = n6 + 1;
                while (n4 < NFINGERS) {
                    if (this.status[n6][n4] == 3) {
                        this.status[n6][n4] = 2;
                    }
                    ++n4;
                }
                ++n6;
            }
            n4 = n5 + 1;
            int n7 = this.idisp - 1;
            if (this.buf[n5] == -127) {
                n7 -= 2;
            }
            int n8 = n4;
            while (n8 < n7) {
                n3 = -1;
                n2 = -1;
                int n9 = 0;
                while (n9 < 5) {
                    if ((this.buf[n8] & 1 << n9) != 0) {
                        if (n3 == -1) {
                            n3 = n9 + 5;
                        } else if (n2 == -1) {
                            n2 = n9 + 5;
                        }
                    }
                    ++n9;
                }
                int n10 = 0;
                while (n10 < 5) {
                    if ((this.buf[n8 + 1] & 1 << n10) != 0) {
                        if (n3 == -1) {
                            n3 = n10;
                        } else if (n2 == -1) {
                            n2 = n10;
                        }
                    }
                    ++n10;
                }
                if (n3 > n2) {
                    int n11 = n3;
                    n3 = n2;
                    n2 = n11;
                }
                if (n3 != -1 && n2 != -1) {
                    if (this.status[n3][n2] == 1) {
                        this.status[n3][n2] = 3;
                        this.listener.pinchTouched(new PinchEvent(n3, n2));
                    } else if (this.status[n3][n2] == 2) {
                        this.status[n3][n2] = 3;
                    }
                }
                n8 += 2;
            }
            n3 = 0;
            while (n3 < NFINGERS) {
                n2 = n3 + 1;
                while (n2 < NFINGERS) {
                    if (this.status[n3][n2] == 2) {
                        this.status[n3][n2] = 1;
                        this.listener.pinchReleased(new PinchEvent(n3, n2));
                    }
                    ++n2;
                }
                ++n3;
            }
        }
        if (this.idisp == this.iread) {
            this.idisp = 0;
            this.iread = 0;
        }
    }
}

