/*
 * Decompiled with CFR 0.152.
 */
package jwsu.viewbranch;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.comm.CommPortIdentifier;
import javax.comm.SerialPort;
import javax.media.j3d.InputDevice;
import javax.media.j3d.Sensor;
import javax.media.j3d.SensorRead;
import javax.media.j3d.Transform3D;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

class InputDeviceLiberty
implements InputDevice {
    private final int npol;
    private boolean dofast;
    private SerialPort serialPort;
    private InputStream inputStream;
    private OutputStream mOutputStream;
    private Sensor[] sensors;
    private final int NEYEREAD = 1000;
    private static final int MAXEYEBUF = 200000;
    private int neyebuf;
    private byte[] eyebuf;
    private Vector3d pos;
    private Point3d angle;
    private Transform3D trans;
    private Transform3D temp;
    private int[] dataRec;
    private int[] Fast;
    private int StartByte;

    public static void main(String[] stringArray) {
        int n = 2;
        InputDeviceLiberty inputDeviceLiberty = new InputDeviceLiberty(n, 115200, "/dev/term/a");
        int n2 = 0;
        while (n2 < 10000) {
            inputDeviceLiberty.pollAndProcessInput();
            int n3 = 0;
            while (n3 < n) {
                Transform3D transform3D = new Transform3D();
                inputDeviceLiberty.getSensor(n3).getCurrentSensorRead().get(transform3D);
                Vector3d vector3d = new Vector3d();
                Matrix3d matrix3d = new Matrix3d();
                transform3D.get(matrix3d, vector3d);
                ++n3;
            }
            ++n2;
        }
    }

    public InputDeviceLiberty(int n, int n2, String string, boolean bl) {
        this(n, n2, string);
        this.dofast = bl;
    }

    public InputDeviceLiberty(int n, int n2, String string) {
        block7: {
            this.dofast = false;
            this.serialPort = null;
            this.inputStream = null;
            this.mOutputStream = null;
            this.NEYEREAD = 1000;
            this.neyebuf = 0;
            this.eyebuf = new byte[200000];
            this.pos = new Vector3d();
            this.angle = new Point3d();
            this.trans = new Transform3D();
            this.temp = new Transform3D();
            this.dataRec = new int[34];
            this.Fast = new int[4];
            this.StartByte = 0;
            this.npol = n;
            this.sensors = new Sensor[n];
            int n3 = 0;
            while (n3 < n) {
                this.sensors[n3] = new Sensor((InputDevice)this);
                ++n3;
            }
            try {
                CommPortIdentifier commPortIdentifier = CommPortIdentifier.getPortIdentifier((String)string);
                this.serialPort = (SerialPort)commPortIdentifier.open("ISCAN", 5000);
                this.serialPort.setSerialPortParams(n2, 8, 1, 0);
                this.serialPort.setFlowControlMode(0);
                this.serialPort.enableReceiveThreshold(1);
                this.serialPort.enableReceiveTimeout(1);
                this.inputStream = this.serialPort.getInputStream();
                this.mOutputStream = this.serialPort.getOutputStream();
                int n4 = 1;
                while (n4 <= n) {
                    String string2 = "O" + n4 + ",2,4,1\r";
                    this.mOutputStream.write(string2.getBytes(), 0, string2.length());
                    ++n4;
                }
                this.mOutputStream.write("F1\r".getBytes(), 0, "F1\r".length());
                this.mOutputStream.write("U1\r".getBytes(), 0, "U1\r".length());
                this.mOutputStream.flush();
                this.mOutputStream.write("C\r".getBytes(), 0, "C\r".length());
            }
            catch (Exception exception) {
                System.err.println("Error opening stream on device: " + exception);
                try {
                    if (this.inputStream != null) {
                        this.inputStream.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                if (this.serialPort == null) break block7;
                this.serialPort.close();
            }
        }
    }

    public void close() {
    }

    public Sensor getSensor(int n) {
        return this.sensors[n];
    }

    public int getSensorCount() {
        return this.npol;
    }

    public boolean initialize() {
        return true;
    }

    public void processStreamInput() {
    }

    public void setNominalPositionAndOrientation() {
    }

    public int getProcessingMode() {
        return 3;
    }

    public void setProcessingMode(int n) {
    }

    public void pollAndProcessInput() {
        int n = 0;
        int n2 = 0;
        while (n2 < 2) {
            if (this.neyebuf + 1000 > 200000) {
                System.err.println("Error: tracker input buffer overflow, discarding buffer");
                this.neyebuf = 0;
                this.StartByte = 0;
            }
            try {
                n = this.inputStream.read(this.eyebuf, this.neyebuf, 1000);
            }
            catch (IOException iOException) {
                System.err.println("Error reading tracker: " + iOException);
            }
            if (n <= 0) break;
            this.neyebuf += n;
            ++n2;
        }
        int n3 = 0;
        while (n3 < 4) {
            this.Fast[n3] = 0;
            ++n3;
        }
        if (this.dofast && this.neyebuf - this.StartByte > this.npol * 30 * 3) {
            this.StartByte = this.neyebuf - this.npol * 30 * 3;
        }
        int n4 = this.StartByte;
        while (n4 < this.neyebuf) {
            if (this.neyebuf - 34 >= 0 && n4 <= this.neyebuf - 34 && this.eyebuf[n4 + 32] == 13 && this.eyebuf[n4 + 33] == 10) {
                int n5;
                int n6;
                int n7 = n4;
                int n8 = 0;
                while (n7 <= n4 + 31) {
                    this.dataRec[n8] = 0xFF & this.eyebuf[n7];
                    ++n7;
                    ++n8;
                }
                int n9 = this.dataRec[2] - 1;
                if (n9 >= 0 && n9 < this.npol) {
                    int n10 = n9;
                    this.Fast[n10] = this.Fast[n10] + 1;
                    n6 = 0;
                    int n11 = 0;
                    int n12 = 0;
                    int n13 = 0;
                    int n14 = 0;
                    n5 = 0;
                    while (n5 < 3) {
                        n6 = this.dataRec[8 + 4 * n5];
                        n11 = this.dataRec[9 + 4 * n5];
                        n12 = this.dataRec[10 + 4 * n5];
                        n13 = this.dataRec[11 + 4 * n5];
                        n14 = n13 << 24 | n12 << 16 | n11 << 8 | n6;
                        if (n5 == 0) {
                            this.pos.z = -Float.intBitsToFloat(n14);
                        } else if (n5 == 1) {
                            this.pos.x = Float.intBitsToFloat(n14);
                        } else if (n5 == 2) {
                            this.pos.y = -Float.intBitsToFloat(n14);
                        }
                        ++n5;
                    }
                    n5 = 0;
                    while (n5 < 3) {
                        n6 = this.dataRec[20 + 4 * n5];
                        n11 = this.dataRec[21 + 4 * n5];
                        n12 = this.dataRec[22 + 4 * n5];
                        n13 = this.dataRec[23 + 4 * n5];
                        n14 = n13 << 24 | n12 << 16 | n11 << 8 | n6;
                        if (n5 == 0) {
                            this.angle.x = Float.intBitsToFloat(n14);
                        } else if (n5 == 1) {
                            this.angle.y = Float.intBitsToFloat(n14);
                        } else if (n5 == 2) {
                            this.angle.z = Float.intBitsToFloat(n14);
                        }
                        ++n5;
                    }
                    this.trans.set(this.pos);
                    this.temp.rotY(-Math.toRadians(this.angle.x));
                    this.trans.mul(this.temp);
                    this.temp.rotX(Math.toRadians(this.angle.y));
                    this.trans.mul(this.temp);
                    this.temp.rotZ(-Math.toRadians(this.angle.z));
                    this.trans.mul(this.temp);
                    SensorRead sensorRead = new SensorRead();
                    sensorRead.set(this.trans);
                    this.sensors[n9].setNextSensorRead(sensorRead);
                }
                n5 = 0;
                n6 = 0;
                while (n6 < this.npol) {
                    if (this.Fast[n6] != 0) {
                        ++n5;
                    }
                    ++n6;
                }
                if (n5 == this.npol) {
                    this.StartByte = n4 + 34;
                    return;
                }
            }
            ++n4;
        }
        this.neyebuf = 0;
        this.StartByte = 0;
    }
}

