/*
 * Decompiled with CFR 0.152.
 */
package jwsu.viewbranch;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.comm.CommPortIdentifier;
import javax.comm.SerialPort;
import javax.media.j3d.InputDevice;
import javax.media.j3d.Sensor;
import javax.media.j3d.SensorRead;
import javax.media.j3d.Transform3D;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

class InputDeviceFlockBirdsAsync
implements InputDevice {
    private final int npol;
    private SerialPort serialPort;
    private InputStream inputStream;
    private OutputStream mOutputStream;
    private Sensor[] sensors;
    private final int NEYEREAD = 1000;
    private static final int MAXEYEBUF = 200000;
    private int neyebuf;
    private byte[] eyebuf;
    private final byte[] AutoConfigCMD_1;
    private final byte[] AutoConfigCMD_2;
    private final byte[] GroupCMD;
    private final byte[] PointCMD;
    private final byte[] PosAngleCMD;
    private final byte[] RS232toFBB_CMD_2ndSensor;
    private final byte[] STREAM_CMD;
    private Vector3d pos;
    private Point3d angle;
    private Transform3D trans;
    private Transform3D temp;
    private int StartByte;
    private int[] Fast;

    public static void main(String[] stringArray) {
        int n = 2;
        InputDeviceFlockBirdsAsync inputDeviceFlockBirdsAsync = new InputDeviceFlockBirdsAsync(n, 38400, "/dev/term/a");
        int n2 = 0;
        while (n2 < 1000000) {
            inputDeviceFlockBirdsAsync.pollAndProcessInput();
            int n3 = 0;
            while (n3 < n) {
                Transform3D transform3D = new Transform3D();
                inputDeviceFlockBirdsAsync.getSensor(n3).getCurrentSensorRead().get(transform3D);
                Vector3d vector3d = new Vector3d();
                Matrix3d matrix3d = new Matrix3d();
                transform3D.get(matrix3d, vector3d);
                System.out.println("SensorRead v " + n3 + " = " + (String.valueOf(vector3d.x) + "     ").substring(0, 5) + " " + (String.valueOf(vector3d.y) + "     ").substring(0, 5) + " " + (String.valueOf(vector3d.z) + "     ").substring(0, 5));
                ++n3;
            }
            ++n2;
        }
    }

    public InputDeviceFlockBirdsAsync(int n, int n2, String string) {
        block10: {
            this.serialPort = null;
            this.inputStream = null;
            this.mOutputStream = null;
            this.NEYEREAD = 1000;
            this.neyebuf = 0;
            this.eyebuf = new byte[200000];
            this.AutoConfigCMD_1 = new byte[]{80, 50, 1};
            this.AutoConfigCMD_2 = new byte[]{80, 50, 2};
            this.GroupCMD = new byte[]{80, 35, 1};
            this.PointCMD = new byte[]{66};
            this.PosAngleCMD = new byte[]{89};
            this.RS232toFBB_CMD_2ndSensor = new byte[]{-14};
            this.STREAM_CMD = new byte[]{64};
            this.pos = new Vector3d();
            this.angle = new Point3d();
            this.trans = new Transform3D();
            this.temp = new Transform3D();
            this.StartByte = 0;
            this.Fast = new int[4];
            this.npol = n;
            this.sensors = new Sensor[n];
            int n3 = 0;
            while (n3 < n) {
                this.sensors[n3] = new Sensor((InputDevice)this);
                ++n3;
            }
            try {
                CommPortIdentifier commPortIdentifier = CommPortIdentifier.getPortIdentifier((String)string);
                this.serialPort = (SerialPort)commPortIdentifier.open("ISCAN", 5000);
                this.serialPort.setSerialPortParams(n2, 8, 1, 0);
                this.serialPort.setFlowControlMode(0);
                this.serialPort.enableReceiveThreshold(1);
                this.serialPort.enableReceiveTimeout(1);
                this.inputStream = this.serialPort.getInputStream();
                this.mOutputStream = this.serialPort.getOutputStream();
                this.serialPort.setDTR(true);
                this.serialPort.setRTS(false);
                if (n == 1) {
                    Thread.sleep(900L);
                    this.mOutputStream.write(this.AutoConfigCMD_1);
                    this.mOutputStream.flush();
                    Thread.sleep(900L);
                    this.mOutputStream.write(this.PosAngleCMD);
                    this.mOutputStream.flush();
                    Thread.sleep(900L);
                    this.mOutputStream.write(this.STREAM_CMD);
                    this.mOutputStream.flush();
                } else if (n == 2) {
                    Thread.sleep(900L);
                    this.mOutputStream.write(this.AutoConfigCMD_2);
                    this.mOutputStream.flush();
                    Thread.sleep(900L);
                    this.mOutputStream.write(this.GroupCMD);
                    Thread.sleep(900L);
                    this.mOutputStream.write(this.PosAngleCMD);
                    this.mOutputStream.flush();
                    Thread.sleep(900L);
                    this.mOutputStream.write(this.STREAM_CMD);
                    this.mOutputStream.flush();
                } else {
                    System.err.println("Not implemented yet for more than 2 sensors!!!");
                    System.exit(-1);
                }
            }
            catch (Exception exception) {
                System.err.println("Error opening stream on device: " + exception);
                try {
                    if (this.inputStream != null) {
                        this.inputStream.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                if (this.serialPort == null) break block10;
                this.serialPort.close();
            }
        }
    }

    public void close() {
    }

    public Sensor getSensor(int n) {
        return this.sensors[n];
    }

    public int getSensorCount() {
        return this.npol;
    }

    public boolean initialize() {
        return true;
    }

    public void processStreamInput() {
    }

    public void setNominalPositionAndOrientation() {
    }

    public int getProcessingMode() {
        return 3;
    }

    public void setProcessingMode(int n) {
    }

    public void pollAndProcessInput() {
        int n = -1;
        int n2 = 0;
        int[] nArray = new int[30];
        int n3 = 0;
        while (n3 < 2) {
            if (this.neyebuf + 1000 > 200000) {
                System.err.println("Error: tracker input buffer overflow, discarding buffer");
                this.neyebuf = 0;
                this.StartByte = 0;
            }
            try {
                n2 = this.inputStream.read(this.eyebuf, this.neyebuf, 1000);
            }
            catch (IOException iOException) {
                System.err.println("Error reading tracker: " + iOException);
            }
            if (n2 <= 0) break;
            this.neyebuf += n2;
            ++n3;
        }
        int n4 = 0;
        while (n4 < 4) {
            this.Fast[n4] = 0;
            ++n4;
        }
        boolean bl = true;
        if (bl && this.neyebuf - this.StartByte > this.npol * 13 * 4) {
            this.StartByte = this.neyebuf - this.npol * 13 * 4;
        }
        int n5 = this.StartByte;
        while (n5 < this.neyebuf) {
            int n6;
            int n7;
            n = -1;
            if (this.neyebuf - 13 >= 0 && n5 <= this.neyebuf - 13 && (this.eyebuf[n5] & 0xFFFFFF80) != 0) {
                n7 = n5;
                n6 = 0;
                while (n7 <= n5 + 12) {
                    nArray[n6] = 0xFF & this.eyebuf[n7];
                    ++n7;
                    ++n6;
                }
                if (this.npol > 1) {
                    if (nArray[12] > 0 || nArray[12] <= this.npol) {
                        n = nArray[12];
                        int n8 = --n;
                        this.Fast[n8] = this.Fast[n8] + 1;
                    } else {
                        System.err.println("WHAT sensor id is this? ('exit' for now, may need to 'continue' instead)" + n);
                        System.exit(-1);
                    }
                } else {
                    int n9 = n = 0;
                    this.Fast[n9] = this.Fast[n9] + 1;
                }
                short s = (short)((short)((short)nArray[0] & 0x7F | (short)nArray[1] << 7) << 2);
                float f = (float)(s * 36) / 32767.0f;
                short s2 = (short)((short)((short)nArray[2] & 0x7F | (short)nArray[3] << 7) << 2);
                float f2 = (float)(s2 * 36) / 32767.0f;
                short s3 = (short)((short)((short)nArray[4] & 0x7F | (short)nArray[5] << 7) << 2);
                float f3 = (float)(s3 * 36) / 32767.0f;
                short s4 = (short)((short)((short)nArray[6] & 0x7F | (short)nArray[7] << 7) << 2);
                float f4 = (float)(s4 * 180) / 32767.0f;
                short s5 = (short)((short)((short)nArray[8] & 0x7F | (short)nArray[9] << 7) << 2);
                float f5 = (float)(s5 * 180) / 32767.0f;
                short s6 = (short)((short)((short)nArray[10] & 0x7F | (short)nArray[11] << 7) << 2);
                float f6 = (float)(s6 * 180) / 32767.0f;
                this.pos.x = -f2;
                this.pos.y = -f3;
                this.pos.z = f;
                this.angle.x = f6;
                this.angle.y = f5;
                this.angle.z = 180.0 - (double)f4;
                this.trans.set(this.pos);
                this.temp.rotY(Math.toRadians(this.angle.z));
                this.trans.mul(this.temp);
                this.temp.rotX(Math.toRadians(this.angle.y));
                this.trans.mul(this.temp);
                this.temp.rotZ(-Math.toRadians(this.angle.x));
                this.trans.mul(this.temp);
                SensorRead sensorRead = new SensorRead();
                sensorRead.set(this.trans);
                this.sensors[n].setNextSensorRead(sensorRead);
            }
            n7 = 0;
            n6 = 0;
            while (n6 < this.npol) {
                if (this.Fast[n6] != 0) {
                    ++n7;
                }
                ++n6;
            }
            if (n7 == this.npol) {
                this.StartByte = this.npol == 1 ? n5 + 12 : n5 + 13;
                return;
            }
            ++n5;
        }
        this.neyebuf = 0;
        this.StartByte = 0;
    }
}

