/*
 * Decompiled with CFR 0.152.
 */
package jwsu.viewbranch;

import java.io.IOException;
import java.io.OutputStream;
import javax.media.j3d.SensorRead;
import javax.media.j3d.Transform3D;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import jwsu.viewbranch.InputDeviceEye;

class InputDeviceFlockBirds
extends InputDeviceEye {
    private final int npol;
    protected OutputStream mOutputStream;
    private final byte[] AutoConfigCMD_1;
    private final byte[] AutoConfigCMD_2;
    private final byte[] GroupCMD;
    private final byte[] PointCMD;
    private final byte[] PosAngleCMD;
    private final byte[] RS232toFBB_CMD_2ndSensor;
    private Vector3d pos;
    private Point3d angle;
    private Transform3D trans;
    private Transform3D temp;

    public static void main(String[] stringArray) {
        int n = 2;
        InputDeviceFlockBirds inputDeviceFlockBirds = new InputDeviceFlockBirds(n, 38400, "/dev/term/b");
        int n2 = 0;
        while (n2 < 1000000) {
            inputDeviceFlockBirds.pollAndProcessInput();
            int n3 = 0;
            while (n3 < n) {
                Transform3D transform3D = new Transform3D();
                inputDeviceFlockBirds.getSensor(n3).getCurrentSensorRead().get(transform3D);
                Vector3d vector3d = new Vector3d();
                Matrix3d matrix3d = new Matrix3d();
                transform3D.get(matrix3d, vector3d);
                System.out.println("SensorRead v " + n3 + " = " + (String.valueOf(vector3d.x) + "     ").substring(0, 5) + " " + (String.valueOf(vector3d.y) + "     ").substring(0, 5) + " " + (String.valueOf(vector3d.z) + "     ").substring(0, 5));
                ++n3;
            }
            ++n2;
        }
    }

    public InputDeviceFlockBirds(int n, int n2, String string) {
        block11: {
            super(n, n2, string);
            this.mOutputStream = null;
            this.AutoConfigCMD_1 = new byte[]{80, 50, 1};
            this.AutoConfigCMD_2 = new byte[]{80, 50, 2};
            this.GroupCMD = new byte[]{80, 35, 1};
            this.PointCMD = new byte[]{66};
            this.PosAngleCMD = new byte[]{89};
            this.RS232toFBB_CMD_2ndSensor = new byte[]{-14};
            this.pos = new Vector3d();
            this.angle = new Point3d();
            this.trans = new Transform3D();
            this.temp = new Transform3D();
            this.npol = n;
            try {
                if (this.device.startsWith("<")) {
                    System.err.println("This class does NOT support input from file!");
                    System.exit(-1);
                } else {
                    this.mOutputStream = this.serialPort.getOutputStream();
                    this.serialPort.setDTR(true);
                    this.serialPort.setRTS(false);
                    if (n == 1) {
                        Thread.sleep(900L);
                        this.mOutputStream.write(this.AutoConfigCMD_1);
                        this.mOutputStream.flush();
                        Thread.sleep(900L);
                        this.mOutputStream.write(this.PointCMD);
                        this.mOutputStream.flush();
                        this.mOutputStream.write(this.PosAngleCMD);
                        this.mOutputStream.flush();
                    } else if (n == 2) {
                        Thread.sleep(900L);
                        this.mOutputStream.write(this.AutoConfigCMD_2);
                        this.mOutputStream.flush();
                        Thread.sleep(900L);
                        this.mOutputStream.write(this.GroupCMD);
                        Thread.sleep(900L);
                        this.mOutputStream.write(this.PointCMD);
                        this.mOutputStream.flush();
                        Thread.sleep(900L);
                        this.mOutputStream.write(this.PosAngleCMD);
                        this.mOutputStream.flush();
                    } else {
                        System.err.println("Not implemented yet!!!");
                        System.exit(-1);
                    }
                }
            }
            catch (Exception exception) {
                System.err.println("Error opening stream on device: " + exception);
                try {
                    if (this.inputStream != null) {
                        this.inputStream.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                if (this.serialPort == null) break block11;
                this.serialPort.close();
            }
        }
    }

    public void pollAndProcessInput() {
        int[] nArray = new int[30];
        try {
            this.mOutputStream.write(this.PointCMD);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n = 0;
        while (n < this.npol) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            int n2 = 0;
            while (n2 < 12) {
                try {
                    nArray[n2] = this.inputStream.read();
                }
                catch (IOException iOException) {
                    System.err.println("Error reading eye tracker: " + iOException);
                }
                ++n2;
            }
            if (this.npol > 1) {
                try {
                    int n3 = this.inputStream.read();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            short s = (short)((short)((short)nArray[0] & 0x7F | (short)nArray[1] << 7) << 2);
            float f = (float)(s * 36) / 32767.0f;
            short s2 = (short)((short)((short)nArray[2] & 0x7F | (short)nArray[3] << 7) << 2);
            float f2 = (float)(s2 * 36) / 32767.0f;
            short s3 = (short)((short)((short)nArray[4] & 0x7F | (short)nArray[5] << 7) << 2);
            float f3 = (float)(s3 * 36) / 32767.0f;
            short s4 = (short)((short)((short)nArray[6] & 0x7F | (short)nArray[7] << 7) << 2);
            float f4 = (float)(s4 * 180) / 32767.0f;
            short s5 = (short)((short)((short)nArray[8] & 0x7F | (short)nArray[9] << 7) << 2);
            float f5 = (float)(s5 * 180) / 32767.0f;
            short s6 = (short)((short)((short)nArray[10] & 0x7F | (short)nArray[11] << 7) << 2);
            float f6 = (float)(s6 * 180) / 32767.0f;
            this.pos.x = -f2;
            this.pos.y = -f3;
            this.pos.z = f;
            this.angle.x = f6;
            this.angle.y = f5;
            this.angle.z = 180.0 - (double)f4;
            this.trans.set(this.pos);
            this.temp.rotY(Math.toRadians(this.angle.z));
            this.trans.mul(this.temp);
            this.temp.rotX(Math.toRadians(this.angle.y));
            this.trans.mul(this.temp);
            this.temp.rotZ(-Math.toRadians(this.angle.x));
            this.trans.mul(this.temp);
            SensorRead sensorRead = new SensorRead();
            sensorRead.set(this.trans);
            this.sensors[n].setNextSensorRead(sensorRead);
            ++n;
        }
    }
}

