/*
 * Decompiled with CFR 0.152.
 */
package jwsu.viewbranch;

import java.io.IOException;
import java.io.InputStream;
import javax.comm.CommPortIdentifier;
import javax.comm.SerialPort;
import javax.media.j3d.InputDevice;
import javax.media.j3d.Sensor;
import javax.vecmath.Point2d;

public class InputDeviceEyeOnly
implements InputDevice {
    private String device;
    private SerialPort serialPort;
    private InputStream inputStream;
    private final int NEYEREAD = 1000;
    private Point2d latestEyePos;
    private static final int MAXEYEBUF = 200000;
    private byte[] eyebuf;
    private int neyebuf;
    private boolean got44;
    private int d;
    private byte hibyte;
    private byte lowbyte;
    private int n;

    public static void main(String[] stringArray) {
        InputDeviceEyeOnly inputDeviceEyeOnly = new InputDeviceEyeOnly(38400, "COM1");
        int n = 0;
        while (n < 10000) {
            inputDeviceEyeOnly.pollAndProcessInput();
            System.out.println("Eye: " + inputDeviceEyeOnly.getEyePos());
            ++n;
        }
    }

    public InputDeviceEyeOnly(int n, String string) {
        block5: {
            this.device = "/dev/term/b";
            this.serialPort = null;
            this.inputStream = null;
            this.NEYEREAD = 1000;
            this.latestEyePos = new Point2d();
            this.eyebuf = new byte[200000];
            this.neyebuf = 0;
            this.got44 = false;
            this.d = 0;
            this.device = string;
            try {
                CommPortIdentifier commPortIdentifier = CommPortIdentifier.getPortIdentifier((String)this.device);
                this.serialPort = (SerialPort)commPortIdentifier.open("ISCAN_Eye_Tracker", 5000);
                this.serialPort.setSerialPortParams(n, 8, 1, 0);
                this.serialPort.setFlowControlMode(0);
                this.serialPort.enableReceiveThreshold(1);
                this.serialPort.enableReceiveTimeout(1);
                this.inputStream = this.serialPort.getInputStream();
            }
            catch (Exception exception) {
                System.err.println("Error opening device: " + exception);
                try {
                    if (this.inputStream != null) {
                        this.inputStream.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                if (this.serialPort == null) break block5;
                this.serialPort.close();
            }
        }
    }

    public Sensor getSensor(int n) {
        return null;
    }

    public int getSensorCount() {
        return 0;
    }

    public boolean initialize() {
        return true;
    }

    public void close() {
    }

    public void processStreamInput() {
    }

    public void setNominalPositionAndOrientation() {
    }

    public int getProcessingMode() {
        return 3;
    }

    public void setProcessingMode(int n) {
    }

    public void pollAndProcessInput() {
        int n = 0;
        int n2 = 0;
        while (n2 < 2) {
            if (this.neyebuf + 1000 > 200000) {
                System.err.println("Error: Eye tracker input buffer overflow, discarding buffer");
                this.neyebuf = 0;
            }
            try {
                n = this.inputStream.read(this.eyebuf, this.neyebuf, 1000);
            }
            catch (IOException iOException) {
                System.err.println("Error reading eye tracker: " + iOException);
            }
            if (n <= 0) break;
            this.neyebuf += n;
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.neyebuf) {
            if (!this.got44 && this.eyebuf[n3] == 68) {
                this.got44 = true;
            } else if (this.got44 && this.eyebuf[n3] == 68) {
                this.got44 = false;
                if (n3 + 4 >= this.neyebuf) break;
                this.lowbyte = this.eyebuf[n3 + 1];
                this.hibyte = this.eyebuf[n3 + 2];
                this.latestEyePos.x = (this.hibyte & 0xFF) << 8 | this.lowbyte & 0xFF;
                this.latestEyePos.x /= 10.0;
                this.lowbyte = this.eyebuf[n3 + 3];
                this.hibyte = this.eyebuf[n3 + 4];
                this.latestEyePos.y = (this.hibyte & 0xFF) << 8 | this.lowbyte & 0xFF;
                this.latestEyePos.y /= 10.0;
                n3 += 4;
            }
            ++n3;
        }
        this.neyebuf = 0;
    }

    public Point2d getEyePos() {
        return this.latestEyePos;
    }

    private double scale(double d, double d2, double d3, double d4, double d5) {
        double d6 = d4 + (d - d2) * d5 / d3;
        if (d6 < d4) {
            return d4;
        }
        if (d6 > d4 + d5) {
            return d4 + d5;
        }
        return d6;
    }
}

