/*
 * Decompiled with CFR 0.152.
 */
package jwsu.viewbranch;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.comm.CommPortIdentifier;
import javax.comm.SerialPort;
import javax.media.j3d.InputDevice;
import javax.media.j3d.Sensor;
import javax.media.j3d.SensorRead;
import javax.media.j3d.Transform3D;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

class InputDeviceEye
implements InputDevice {
    protected String device;
    protected SerialPort serialPort;
    protected InputStream inputStream;
    protected final int NEYEREAD = 1000;
    private final int npol;
    private Point3d[] offsetPos;
    private Point3d[] offsetAngle;
    private boolean[] doPoltoeye;
    private Point2d latestEyePos;
    private float latestEyeDiam;
    protected Sensor[] sensors;
    protected static final int MAXEYEBUF = 200000;
    protected byte[] eyebuf;
    protected int neyebuf;
    private boolean got44;
    private boolean first;
    protected int[] data;
    protected int d;
    private byte hibyte;
    private byte lowbyte;
    private int n;
    private Vector3d poltoeyePos;
    private Point3d poltoeyeAngle;
    private Vector3d pos;
    private Point3d angle;
    private Transform3D trans;
    private Transform3D temp;
    private Point3d poltoeyeTemp;

    public static void main(String[] stringArray) {
        InputDeviceEye inputDeviceEye = new InputDeviceEye(3, 38400, "/dev/term/b");
        int n = 0;
        while (n < 10000) {
            inputDeviceEye.pollAndProcessInput();
            int n2 = 0;
            while (n2 < 3) {
                Transform3D transform3D = new Transform3D();
                inputDeviceEye.getSensor(n2).getCurrentSensorRead().get(transform3D);
                Vector3d vector3d = new Vector3d();
                Matrix3d matrix3d = new Matrix3d();
                transform3D.get(matrix3d, vector3d);
                System.out.println("SensorRead v " + n2 + " = " + (String.valueOf(vector3d.x) + "     ").substring(0, 5) + " " + (String.valueOf(vector3d.y) + "     ").substring(0, 5) + " " + (String.valueOf(vector3d.z) + "     ").substring(0, 5));
                ++n2;
            }
            ++n;
        }
    }

    public InputDeviceEye(int n, int n2, String string) {
        block8: {
            this.device = "/dev/term/b";
            this.serialPort = null;
            this.inputStream = null;
            this.NEYEREAD = 1000;
            this.latestEyePos = new Point2d();
            this.eyebuf = new byte[200000];
            this.neyebuf = 0;
            this.got44 = false;
            this.first = true;
            this.data = new int[100000];
            this.d = 0;
            this.poltoeyePos = new Vector3d(8.5, -3.5, 1.38);
            this.poltoeyeAngle = new Point3d(0.0, 12.0, 6.0);
            this.pos = new Vector3d();
            this.angle = new Point3d();
            this.trans = new Transform3D();
            this.temp = new Transform3D();
            this.poltoeyeTemp = new Point3d();
            this.npol = n;
            this.device = string;
            this.offsetPos = new Point3d[n];
            this.offsetAngle = new Point3d[n];
            this.doPoltoeye = new boolean[n];
            this.sensors = new Sensor[n];
            int n3 = 0;
            while (n3 < n) {
                this.offsetPos[n3] = new Point3d();
                this.offsetAngle[n3] = new Point3d();
                this.doPoltoeye[n3] = false;
                this.sensors[n3] = new Sensor((InputDevice)this);
                ++n3;
            }
            try {
                if (this.device.startsWith("<")) {
                    this.inputStream = new FileInputStream(new File(this.device.substring(1)));
                } else {
                    CommPortIdentifier commPortIdentifier = CommPortIdentifier.getPortIdentifier((String)this.device);
                    this.serialPort = (SerialPort)commPortIdentifier.open("ISCAN", 5000);
                    this.serialPort.setSerialPortParams(n2, 8, 1, 0);
                    this.serialPort.setFlowControlMode(0);
                    this.serialPort.enableReceiveThreshold(1);
                    this.serialPort.enableReceiveTimeout(1);
                    this.inputStream = this.serialPort.getInputStream();
                }
            }
            catch (Exception exception) {
                System.err.println("Error opening device: " + exception);
                try {
                    if (this.inputStream != null) {
                        this.inputStream.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                if (this.serialPort == null) break block8;
                this.serialPort.close();
            }
        }
    }

    public void close() {
    }

    public Sensor getSensor(int n) {
        return this.sensors[n];
    }

    public int getSensorCount() {
        return this.npol;
    }

    public boolean initialize() {
        return true;
    }

    public void processStreamInput() {
    }

    public void setNominalPositionAndOrientation() {
    }

    public int getProcessingMode() {
        return 3;
    }

    public void setProcessingMode(int n) {
    }

    public void pollAndProcessInput() {
        int n = 0;
        int n2 = 0;
        while (n2 < 2) {
            if (this.neyebuf + 1000 > 200000) {
                System.err.println("Error: Eye tracker input buffer overflow, discarding buffer");
                this.neyebuf = 0;
            }
            try {
                n = this.inputStream.read(this.eyebuf, this.neyebuf, 1000);
            }
            catch (IOException iOException) {
                System.err.println("Error reading eye tracker: " + iOException);
            }
            if (n <= 0) break;
            this.neyebuf += n;
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.neyebuf) {
            if (this.got44 && this.eyebuf[n3] == 68) {
                if (this.first) {
                    this.data[this.d] = 0;
                    if (this.d > 0) {
                        --this.d;
                    }
                }
                if (this.d == 3 + 6 * this.npol) {
                    this.latestEyePos.x = this.scale(this.data[0], -20.0, 490.0, 0.0, 640.0);
                    this.latestEyePos.y = this.scale(this.data[1], 27.0, 215.0, 0.0, 480.0);
                    this.latestEyeDiam = this.data[2];
                    int n4 = 0;
                    while (n4 < this.npol) {
                        int n5 = 3 + 6 * n4;
                        this.pos.x = (double)(this.data[n5 + 1] < 2048 ? this.data[n5 + 1] : this.data[n5 + 1] - 4095) / 10.0;
                        this.pos.y = (double)(-(this.data[n5 + 2] < 2048 ? this.data[n5 + 2] : this.data[n5 + 2] - 4095)) / 10.0;
                        this.pos.z = (double)(-this.data[n5 + 0]) / 10.0;
                        this.angle.x = (double)(this.data[n5 + 3] > 1800 ? this.data[n5 + 3] - 500 : this.data[n5 + 3]) / 10.0;
                        this.angle.y = (double)(this.data[n5 + 4] > 1800 ? this.data[n5 + 4] - 500 : this.data[n5 + 4]) / 10.0;
                        this.angle.z = (double)(this.data[n5 + 5] > 1800 ? this.data[n5 + 5] - 500 : this.data[n5 + 5]) / 10.0;
                        if (n4 == 0) {
                            this.pos.x = -this.pos.x;
                            this.pos.y = -this.pos.y;
                            this.angle.x = 360.0 - this.angle.x;
                        }
                        if (this.doPoltoeye[n4]) {
                            this.trans.setIdentity();
                            this.temp.rotY(-Math.toRadians(this.angle.x));
                            this.trans.mul(this.temp);
                            this.temp.rotX(Math.toRadians(this.angle.y));
                            this.trans.mul(this.temp);
                            this.temp.rotZ(-Math.toRadians(this.angle.z));
                            this.trans.mul(this.temp);
                            this.poltoeyeTemp.set((Tuple3d)this.poltoeyePos);
                            this.trans.transform(this.poltoeyeTemp);
                            this.pos.add((Tuple3d)this.poltoeyeTemp);
                            this.angle.add((Tuple3d)this.poltoeyeAngle);
                        }
                        this.pos.add((Tuple3d)this.offsetPos[n4]);
                        this.angle.add((Tuple3d)this.offsetAngle[n4]);
                        this.pos.scale(0.0254);
                        this.trans.set(this.pos);
                        this.temp.rotY(-Math.toRadians(this.angle.x));
                        this.trans.mul(this.temp);
                        this.temp.rotX(Math.toRadians(this.angle.y));
                        this.trans.mul(this.temp);
                        this.temp.rotZ(-Math.toRadians(this.angle.z));
                        this.trans.mul(this.temp);
                        SensorRead sensorRead = new SensorRead();
                        sensorRead.set(this.trans);
                        this.sensors[n4].setNextSensorRead(sensorRead);
                        ++n4;
                    }
                }
                this.first = true;
                this.d = 0;
                this.got44 = false;
            } else {
                this.got44 = this.eyebuf[n3] == 68;
                if (this.first) {
                    this.lowbyte = this.eyebuf[n3];
                    this.first = false;
                } else {
                    this.hibyte = this.eyebuf[n3];
                    this.first = true;
                    this.data[this.d++] = (this.hibyte & 0xFF) << 8 | this.lowbyte & 0xFF;
                }
            }
            ++n3;
        }
        this.neyebuf = 0;
    }

    public Point2d getEyePos() {
        return this.latestEyePos;
    }

    public float getEyeDiam() {
        return this.latestEyeDiam;
    }

    public void setPoltoeye(int n) {
        this.doPoltoeye[n] = true;
    }

    public void setOffset(Point3d point3d, Point3d point3d2, int n) {
        if (n == -1) {
            int n2 = 0;
            while (n2 < this.npol) {
                this.offsetPos[n2].set((Tuple3d)point3d);
                this.offsetAngle[n2].set((Tuple3d)point3d2);
                ++n2;
            }
        } else {
            this.offsetPos[n].set((Tuple3d)point3d);
            this.offsetAngle[n].set((Tuple3d)point3d2);
        }
    }

    public void setOffset(Point3d point3d, Point3d point3d2) {
        this.setOffset(point3d, point3d2, -1);
    }

    private double scale(double d, double d2, double d3, double d4, double d5) {
        double d6 = d4 + (d - d2) * d5 / d3;
        if (d6 < d4) {
            return d4;
        }
        if (d6 > d4 + d5) {
            return d4 + d5;
        }
        return d6;
    }
}

