/*
 * Decompiled with CFR 0.152.
 */
package jwsu.viewbranch;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.comm.CommPortIdentifier;
import javax.comm.SerialPort;
import javax.media.j3d.InputDevice;
import javax.media.j3d.Sensor;
import javax.media.j3d.SensorRead;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import jwsu.viewbranch.CyberGloveEvent;
import jwsu.viewbranch.CyberGloveListener;

public class InputDeviceCyberGlove
implements InputDevice {
    private CyberGloveListener listener;
    private static final int OPENED = 0;
    private static final int CLOSED = 1;
    private static final int FLY = 2;
    private static final int DRIVE = 3;
    private int previous_state;
    private int state;
    public static final int THUMB_ROTATION = 0;
    public static final int THUMB_MPJ = 1;
    public static final int THUMB_IJ = 2;
    public static final int THUMB_ABDUCTION = 3;
    public static final int INDEX_MPJ = 4;
    public static final int INDEX_PIJ = 5;
    public static final int INDEX_DIJ = 6;
    public static final int INDEX_ABDUCTION = 7;
    public static final int MIDDLE_MPJ = 8;
    public static final int MIDDLE_PIJ = 9;
    public static final int MIDDLE_DIJ = 10;
    public static final int MIDDLE_INDEX_ABDUCTION = 11;
    public static final int RING_MPJ = 12;
    public static final int RING_PIJ = 13;
    public static final int RING_DIJ = 14;
    public static final int RING_MIDDLE_ABDUCTION = 15;
    public static final int PINKIE_MPJ = 16;
    public static final int PINKIE_PIJ = 17;
    public static final int PINKIE_DIJ = 18;
    public static final int PINKIE_RING_ABDUCTION = 19;
    public static final int PALM_ARCH = 20;
    public static final int WRIST_PITCH = 21;
    public static final int WRIST_YAW = 22;
    private SerialPort serialPort;
    private String device;
    private InputStream inputStream;
    private OutputStream mOutputStream;
    private final int NEYEREAD = 1000;
    private static final int MAXEYEBUF = 200000;
    private byte[] eyebuf;
    private int neyebuf;
    private Sensor[] sensors;
    private int numOfSensors;
    private int[] sensorData;
    private SensorRead sensorRead;
    public boolean RightHand;
    private int NUM_OF_SENSORS;
    private static final String getRecordCommand = "G";
    private static final String getNumberOfSensorsCommand = "?S";
    private static final String getRightHandednessCommand = "?R";
    private static final String setStreamingMode = "S";
    private Vector3d pos;
    private Point3d angle;
    private Transform3D trans;
    private Transform3D temp;
    private int StartByte;

    public int getRecordItem(int n) {
        if (n > -1 && n < 23) {
            return this.sensorData[n];
        }
        System.err.println("There are only 22 (or 18) sensors, and you are requesting the " + n + " element!");
        System.exit(-1);
        return -1;
    }

    private void waitTime(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean initialize() {
        try {
            this.mOutputStream = this.serialPort.getOutputStream();
            int n = 0;
            while (n < this.sensorData.length) {
                this.sensorData[n] = 0;
                ++n;
            }
            this.mOutputStream.write(getNumberOfSensorsCommand.getBytes(), 0, getNumberOfSensorsCommand.length());
            this.mOutputStream.flush();
            this.waitTime(100L);
            this.inputStream.read();
            this.inputStream.read();
            this.numOfSensors = this.inputStream.read();
            this.inputStream.read();
            if (this.numOfSensors != 22) {
                System.err.println(this.numOfSensors + " reported sensors");
            } else {
                System.out.println(this.numOfSensors + " reported sensors");
            }
            this.mOutputStream.write(getRightHandednessCommand.getBytes(), 0, getRightHandednessCommand.length());
            this.mOutputStream.flush();
            this.waitTime(100L);
            this.inputStream.read();
            this.inputStream.read();
            if (this.inputStream.read() == 1) {
                System.out.println("RIGHT HAND");
                this.RightHand = true;
            } else {
                System.out.println("LEFT HAND");
                this.RightHand = false;
            }
            this.inputStream.read();
            this.mOutputStream.write(setStreamingMode.getBytes(), 0, setStreamingMode.length());
            this.mOutputStream.flush();
        }
        catch (Exception exception) {
            System.err.println("Error opening stream on device: " + exception);
            System.err.println(exception.toString() + "Error initializing device, exiting... ");
            try {
                if (this.inputStream != null) {
                    this.inputStream.close();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            if (this.serialPort != null) {
                this.serialPort.close();
            }
            System.exit(-1);
        }
        this.sensors[0] = new Sensor((InputDevice)this, 30, 23);
        this.sensors[0].setPredictionPolicy(64);
        this.sensors[0].setPredictor(2);
        return true;
    }

    public InputDeviceCyberGlove(int n, String string, CyberGloveListener cyberGloveListener) {
        this(n, string, cyberGloveListener, false);
    }

    public InputDeviceCyberGlove(int n, String string, CyberGloveListener cyberGloveListener, boolean bl) {
        block6: {
            this.previous_state = 1;
            this.state = 0;
            this.serialPort = null;
            this.device = "/dev/term/b";
            this.inputStream = null;
            this.mOutputStream = null;
            this.NEYEREAD = 1000;
            this.eyebuf = new byte[200000];
            this.neyebuf = 0;
            this.sensors = new Sensor[1];
            this.numOfSensors = 22;
            this.sensorData = new int[this.numOfSensors + 1];
            this.sensorRead = new SensorRead(this.numOfSensors + 1);
            this.RightHand = false;
            this.NUM_OF_SENSORS = 18;
            this.pos = new Vector3d();
            this.angle = new Point3d();
            this.trans = new Transform3D();
            this.temp = new Transform3D();
            this.StartByte = 0;
            this.device = string;
            this.listener = cyberGloveListener;
            this.NUM_OF_SENSORS = bl ? 22 : 18;
            if (string.startsWith("<")) {
                System.err.println("This class does NOT support input from file!");
                System.exit(-1);
            }
            try {
                CommPortIdentifier commPortIdentifier = CommPortIdentifier.getPortIdentifier((String)string);
                this.serialPort = (SerialPort)commPortIdentifier.open("ISCAN", 5000);
                this.serialPort.setSerialPortParams(n, 8, 1, 0);
                this.serialPort.setFlowControlMode(0);
                this.serialPort.enableReceiveThreshold(1);
                this.serialPort.enableReceiveTimeout(1);
                this.inputStream = this.serialPort.getInputStream();
            }
            catch (Exception exception) {
                System.err.println("Error opening device: " + exception);
                try {
                    if (this.inputStream != null) {
                        this.inputStream.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                if (this.serialPort == null) break block6;
                this.serialPort.close();
            }
        }
        this.initialize();
    }

    public void close() {
    }

    public Sensor getSensor(int n) {
        if (n != 0) {
            System.err.println("sensorIndex must be 0, ONLY 0, nothing else, and it is: " + n);
            System.exit(-1);
        }
        return this.sensors[0];
    }

    public int getSensorCount() {
        return this.numOfSensors;
    }

    public void processStreamInput() {
    }

    public void setNominalPositionAndOrientation() {
    }

    public int getProcessingMode() {
        return 3;
    }

    public void setProcessingMode(int n) {
    }

    public void pollAndProcessInput() {
        int n = 0;
        int n2 = 0;
        while (n2 < 2) {
            if (this.neyebuf + 1000 > 200000) {
                System.err.println("Error: tracker input buffer overflow, discarding buffer");
                this.neyebuf = 0;
                this.StartByte = 0;
            }
            try {
                n = this.inputStream.read(this.eyebuf, this.neyebuf, 1000);
            }
            catch (IOException iOException) {
                System.err.println("Error reading tracker: " + iOException);
            }
            if (n <= 0) break;
            this.neyebuf += n;
            ++n2;
        }
        int n3 = 0;
        int n4 = this.StartByte;
        while (n4 < this.neyebuf) {
            if (this.neyebuf - (this.NUM_OF_SENSORS + 2) >= 0 && n4 <= this.neyebuf - (this.NUM_OF_SENSORS + 2) && this.eyebuf[n4 + this.NUM_OF_SENSORS + 1] == 0) {
                int n5;
                if (this.NUM_OF_SENSORS == 22) {
                    n5 = n4 + 1;
                    while (n5 <= n4 + 22) {
                        if (n3 != 7) {
                            this.sensorData[n3] = 0xFF & this.eyebuf[n5];
                        } else {
                            this.sensorData[n3] = 0;
                            this.sensorData[++n3] = 0xFF & this.eyebuf[n5];
                        }
                        ++n3;
                        ++n5;
                    }
                } else {
                    n5 = n4 + 1;
                    while (n5 <= n4 + 18) {
                        if (n3 == 7 || n3 == 6 || n3 == 10 || n3 == 14 || n3 == 18) {
                            this.sensorData[n3] = 0;
                            this.sensorData[++n3] = 0xFF & this.eyebuf[n5];
                        } else {
                            this.sensorData[n3] = 0xFF & this.eyebuf[n5];
                        }
                        ++n3;
                        ++n5;
                    }
                }
                this.sensorRead.setTime(System.currentTimeMillis());
                this.sensorRead.setButtons(this.sensorData);
                this.sensorRead.set(this.trans);
                this.sensors[0].setNextSensorRead(this.sensorRead);
                this.StartByte = n4 + this.NUM_OF_SENSORS + 2;
                this.callHook();
                n4 += this.NUM_OF_SENSORS + 2;
                n3 = 0;
            }
            ++n4;
        }
        this.neyebuf = 0;
        this.StartByte = 0;
    }

    protected void callHook() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (this.NUM_OF_SENSORS == 22) {
            n = this.getRecordItem(6);
            n2 = this.getRecordItem(10);
            n3 = this.getRecordItem(14);
            n4 = this.getRecordItem(18);
        } else {
            n = this.getRecordItem(4);
            n2 = this.getRecordItem(8);
            n3 = this.getRecordItem(12);
            n4 = this.getRecordItem(16);
        }
        this.state = n > 120 && n2 > 120 && n3 > 120 && n4 > 120 ? 1 : (n < 120 && n2 > 120 && n3 > 120 && n4 > 120 ? 2 : (n < 120 && n2 < 120 && n3 > 120 && n4 > 120 ? 3 : 0));
        if (this.state != this.previous_state) {
            if (this.state == 1) {
                this.listener.CyberGloveTouched(new CyberGloveEvent(n, this.RightHand));
                this.listener.CyberGloveInteract(new CyberGloveEvent(n, this.RightHand));
                System.out.println("TOUCHED/INTERACT");
            } else if (this.state == 0) {
                this.listener.CyberGloveReleased(new CyberGloveEvent(n, this.RightHand));
                this.listener.CyberGloveInteract(new CyberGloveEvent(n, this.RightHand));
                System.out.println("RELEASED/INTERACT");
            } else if (this.state == 2) {
                this.listener.CyberGloveFly(new CyberGloveEvent(n, this.RightHand));
                System.out.println("FLY");
            } else if (this.state == 3) {
                this.listener.CyberGloveDrive(new CyberGloveEvent(n, this.RightHand));
                System.out.println("DRIVE");
            }
            this.previous_state = this.state;
        }
    }
}

