/*
 * Decompiled with CFR 0.152.
 */
package jwsu.viewbranch;

import com.sun.j3d.loaders.IncorrectFormatException;
import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.Scene;
import com.sun.j3d.loaders.objectfile.ObjectFile;
import java.io.FileNotFoundException;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.InputDevice;
import javax.media.j3d.Material;
import javax.media.j3d.Morph;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.vecmath.Color3f;
import jwsu.viewbranch.CyberGloveEvent;
import jwsu.viewbranch.PinchEvent;
import jwsu.viewbranch.VirtualHand;

public class HandMorph
extends VirtualHand {
    protected double[] weights;

    public HandMorph(InputDevice inputDevice, int n) {
        super(inputDevice, n);
        Transform3D transform3D = new Transform3D();
        Transform3D transform3D2 = new Transform3D();
        transform3D.rotZ(Math.toRadians(-180.0));
        transform3D2.setScale(10.0);
        transform3D.mul(transform3D2);
        this.get_forNode().setTransform(transform3D);
        Morph morph = this.CreateMorphHand();
        this.getSwitch().setChild((Node)morph, 0);
        this.setNode((Node)morph);
    }

    private Morph CreateMorphHand() {
        Appearance appearance;
        Scene[] sceneArray = new Scene[3];
        GeometryArray[] geometryArrayArray = new GeometryArray[3];
        Shape3D[] shape3DArray = new Shape3D[3];
        ObjectFile objectFile = new ObjectFile(64);
        int n = 0;
        while (n < 3) {
            sceneArray[n] = null;
            geometryArrayArray[n] = null;
            shape3DArray[n] = null;
            ++n;
        }
        String[] stringArray = new String[]{new String("../images/hand1.obj"), new String("../images/hand2.obj"), new String("../images/hand3.obj")};
        int n2 = 0;
        while (n2 < 3) {
            try {
                sceneArray[n2] = objectFile.load(stringArray[n2]);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println(fileNotFoundException);
                System.exit(1);
            }
            catch (ParsingErrorException parsingErrorException) {
                System.err.println((Object)parsingErrorException);
                System.exit(1);
            }
            catch (IncorrectFormatException incorrectFormatException) {
                System.err.println((Object)incorrectFormatException);
                System.exit(1);
            }
            appearance = sceneArray[n2].getSceneGroup();
            shape3DArray[n2] = (Shape3D)appearance.getChild(0);
            geometryArrayArray[n2] = (GeometryArray)shape3DArray[n2].getGeometry();
            shape3DArray[n2].setGeometry((Geometry)geometryArrayArray[n2]);
            ++n2;
        }
        appearance = new Appearance();
        Color3f color3f = new Color3f(0.2f, 1.0f, 0.4f);
        Color3f color3f2 = new Color3f(0.0f, 0.0f, 0.0f);
        appearance.setMaterial(new Material(color3f, color3f2, color3f, color3f2, 80.0f));
        Morph morph = new Morph(geometryArrayArray, appearance);
        morph.setCapability(16);
        morph.setCapability(17);
        this.weights = morph.getWeights();
        return morph;
    }

    public void CyberGloveTouched(CyberGloveEvent cyberGloveEvent) {
        if (this.WhichHand() == 2 && cyberGloveEvent.isLeft() || this.WhichHand() == 1 && cyberGloveEvent.isRight()) {
            this.weights[0] = 0.0;
            this.weights[1] = 0.4f;
            this.weights[2] = 0.6f;
            ((Morph)this.getNode()).setWeights(this.weights);
            super.CyberGloveTouched(cyberGloveEvent);
        }
    }

    public void CyberGloveReleased(CyberGloveEvent cyberGloveEvent) {
        if (this.WhichHand() == 2 && cyberGloveEvent.isLeft() || this.WhichHand() == 1 && cyberGloveEvent.isRight()) {
            this.weights[0] = 0.6f;
            this.weights[1] = 0.4f;
            this.weights[2] = 0.0;
            ((Morph)this.getNode()).setWeights(this.weights);
            super.CyberGloveReleased(cyberGloveEvent);
        }
    }

    public void pinchTouched(PinchEvent pinchEvent) {
        if (this.WhichHand() == 2 && pinchEvent.isLeft() || this.WhichHand() == 1 && pinchEvent.isRight()) {
            this.weights[0] = 0.0;
            this.weights[1] = 0.4f;
            this.weights[2] = 0.6f;
            ((Morph)this.getNode()).setWeights(this.weights);
            super.pinchTouched(pinchEvent);
        }
    }

    public void pinchReleased(PinchEvent pinchEvent) {
        if (this.WhichHand() == 2 && pinchEvent.isLeft() || this.WhichHand() == 1 && pinchEvent.isRight()) {
            this.weights[0] = 0.6f;
            this.weights[1] = 0.4f;
            this.weights[2] = 0.0;
            ((Morph)this.getNode()).setWeights(this.weights);
            super.pinchReleased(pinchEvent);
        }
    }
}

