/*
 * Decompiled with CFR 0.152.
 */
package jwsu.viewbranch;

import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnElapsedFrames;
import javax.vecmath.Vector3d;
import jwsu.viewbranch.VirtualHandGrow;

class HandBehaviorGrow
extends Behavior {
    private static int IDLE = 0;
    private static int GROW = 1;
    private static int SHRING = 2;
    private int state = IDLE;
    private double incSize = 10.0;
    private TransformGroup tipTG = null;
    protected WakeupOnElapsedFrames conditions = new WakeupOnElapsedFrames(0);
    TransformGroup tg = null;

    public HandBehaviorGrow(VirtualHandGrow virtualHandGrow) {
        this.tg = virtualHandGrow.get_sTG();
        this.tipTG = virtualHandGrow.get_tipTG();
    }

    public void initialize() {
        this.wakeupOn((WakeupCondition)this.conditions);
    }

    public void stateGrow() {
        System.out.println("\tGROWING");
        this.state = GROW;
    }

    public void stateShring() {
        System.out.println("\tSHRINGING");
        this.state = SHRING;
    }

    public void stateIdle() {
        System.out.println("\tIDLE");
        this.state = IDLE;
    }

    public void setIncDec(double d) {
        this.incSize = d;
    }

    public void processStimulus(Enumeration enumeration) {
        if (this.state == GROW || this.state == SHRING) {
            Transform3D transform3D = new Transform3D();
            this.tg.getTransform(transform3D);
            Vector3d vector3d = new Vector3d();
            transform3D.getScale(vector3d);
            if (this.state == GROW) {
                vector3d.z += this.incSize;
                transform3D.setScale(vector3d);
                transform3D.setTranslation(new Vector3d(0.0, 0.0, -vector3d.z * 0.1));
                this.tg.setTransform(transform3D);
                transform3D.setScale(1.0);
                transform3D.setTranslation(new Vector3d(0.0, 0.0, -2.0 * vector3d.z * 0.1));
                this.tipTG.setTransform(transform3D);
            } else if (this.state == SHRING) {
                vector3d.z -= this.incSize;
                if (vector3d.z < 1.0) {
                    vector3d.z = 1.0;
                }
                transform3D.setScale(vector3d);
                transform3D.setTranslation(new Vector3d(0.0, 0.0, -vector3d.z * 0.1));
                this.tg.setTransform(transform3D);
                transform3D.setScale(1.0);
                transform3D.setTranslation(new Vector3d(0.0, 0.0, -2.0 * vector3d.z * 0.1));
                this.tipTG.setTransform(transform3D);
            }
        }
        this.wakeupOn((WakeupCondition)this.conditions);
    }
}

