/*
 * Decompiled with CFR 0.152.
 */
package jwsu.viewbranch;

import java.util.ArrayList;
import java.util.Enumeration;
import javax.media.j3d.Bounds;
import javax.media.j3d.Group;
import javax.media.j3d.Locale;
import javax.media.j3d.Node;
import javax.media.j3d.PickBounds;
import javax.media.j3d.PickShape;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;

public class Draggable {
    private static ArrayList instances = new ArrayList();
    protected final boolean doGeometry = false;
    private TransformGroup transformGroup = null;
    private Node node = null;
    private SceneGraphPath SGPath = null;
    private Locale locale;
    private Transform3D trans = new Transform3D();
    private PickBounds pickBounds = new PickBounds();
    private SceneGraphPath sceneGraphPath = new SceneGraphPath();

    public static void add(Locale locale, TransformGroup transformGroup, Node node) {
        instances.add(new Draggable(locale, transformGroup, node, null));
    }

    public static void add(Locale locale, TransformGroup transformGroup, Node node, SceneGraphPath sceneGraphPath) {
        instances.add(new Draggable(locale, transformGroup, node, sceneGraphPath));
    }

    private Draggable(Locale locale, TransformGroup transformGroup, Node node, SceneGraphPath sceneGraphPath) {
        this.locale = locale;
        this.transformGroup = transformGroup;
        this.node = node;
        this.SGPath = sceneGraphPath;
        transformGroup.setCapability(18);
        transformGroup.setCapability(17);
        node.setCapability(3);
        node.setCapability(11);
    }

    public static final ArrayList getInstances() {
        return instances;
    }

    protected double getVworldToLocal(Transform3D transform3D, Transform3D transform3D2) {
        double d = 0.0;
        Transform3D transform3D3 = new Transform3D();
        this.transformGroup.getTransform(transform3D3);
        if (this.SGPath == null) {
            this.node.getLocalToVworld(transform3D2);
        } else {
            this.node.getLocalToVworld(this.SGPath, transform3D2);
        }
        d = transform3D2.getScale();
        transform3D3.invert();
        transform3D2.mul(transform3D3);
        transform3D2.invert();
        transform3D2.mul(transform3D);
        return d;
    }

    public boolean IsShared() {
        return this.SGPath != null;
    }

    public SceneGraphPath getSGPath() {
        return this.SGPath;
    }

    public void drag(Transform3D transform3D) {
        Transform3D transform3D2 = new Transform3D();
        double d = this.getVworldToLocal(transform3D, transform3D2);
        this.transformGroup.setTransform(transform3D2);
    }

    public boolean intersect(Bounds bounds) {
        if (this.SGPath != null) {
            this.node.getLocalToVworld(this.SGPath, this.trans);
        } else {
            this.node.getLocalToVworld(this.trans);
        }
        Bounds bounds2 = this.node.getBounds();
        bounds2.transform(bounds2, this.trans);
        return bounds2.intersect(bounds);
    }

    private boolean traverse(Node node, PickShape pickShape) {
        if (node instanceof Shape3D) {
            System.out.println("Shape3D");
            Shape3D shape3D = (Shape3D)node;
            this.sceneGraphPath.setObject((Node)shape3D);
            return shape3D.intersect(this.sceneGraphPath, pickShape);
        }
        if (node instanceof Group) {
            System.out.println("Group");
            Enumeration enumeration = ((Group)node).getAllChildren();
            while (enumeration.hasMoreElements()) {
                Node node2 = (Node)enumeration.nextElement();
                if (!this.traverse(node2, pickShape)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public TransformGroup getTG() {
        return this.transformGroup;
    }

    public Node getNode() {
        return this.node;
    }
}

