/*
 * Decompiled with CFR 0.152.
 */
package jwsu.utils;

import java.io.InputStream;
import java.io.OutputStream;
import javax.comm.CommPortIdentifier;
import javax.comm.SerialPort;

class RelayStatusController {
    private SerialPort serialPort = null;
    private InputStream inputStream = null;
    private OutputStream outputStream = null;
    private byte[] byte_code = new byte[1];
    private byte[] status_byte_code = new byte[1];

    public RelayStatusController(String string) {
        this(string, 9600);
    }

    public RelayStatusController(String string, int n) {
        try {
            CommPortIdentifier commPortIdentifier = CommPortIdentifier.getPortIdentifier((String)string);
            this.serialPort = (SerialPort)commPortIdentifier.open("RelayStatusController", 5000);
            this.serialPort.setSerialPortParams(n, 8, 1, 1);
            this.serialPort.setFlowControlMode(0);
            this.inputStream = this.serialPort.getInputStream();
            this.outputStream = this.serialPort.getOutputStream();
        }
        catch (Exception exception) {
            System.err.println("Error opening stream on device: " + exception);
            System.err.println("Failed to open device: " + string);
            System.exit(-1);
        }
    }

    public void Activate(int n) {
        if (n < 1 || n > 8) {
            System.err.println("Wrong relay id to Activate " + n);
            System.exit(-1);
        }
        this.SEND((byte)(33 + (n - 1) * 2));
    }

    public void Deactivate(int n) {
        if (n < 1 || n > 8) {
            System.err.println("Wrong relay id to Deactivate " + n);
            System.exit(-1);
        }
        this.SEND((byte)(32 + (n - 1) * 2));
    }

    void SEND(byte by) {
        block5: {
            this.byte_code[0] = by;
            try {
                this.outputStream.write(this.byte_code, 0, 1);
            }
            catch (Exception exception) {
                System.err.println("Error while transmiting: " + exception);
                try {
                    if (this.inputStream != null) {
                        this.inputStream.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                if (this.serialPort == null) break block5;
                this.serialPort.close();
            }
        }
    }

    public int getStatus(int n) {
        int n2;
        block6: {
            if (n < 1 || n > 2) {
                System.err.println("Wrong input status id requested " + n);
                System.exit(-1);
            }
            this.status_byte_code[0] = (byte)(n - 1);
            n2 = -1;
            try {
                this.outputStream.write(this.status_byte_code, 0, 1);
                n2 = this.inputStream.read();
            }
            catch (Exception exception) {
                System.err.println("Error while transmiting: " + exception);
                try {
                    if (this.inputStream != null) {
                        this.inputStream.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                if (this.serialPort == null) break block6;
                this.serialPort.close();
            }
        }
        return n2;
    }
}

