/*
 * Decompiled with CFR 0.152.
 */
package jwsu.utils;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.Hashtable;

public class OverAndBelowLayout
implements LayoutManager2 {
    private int width;
    private int height;
    private static final int BLANK_INTERVAL = 44;
    private OandB_coords LeftEyePanel = null;
    private OandB_coords RightEyePanel = null;
    private Hashtable info = new Hashtable();

    public OverAndBelowLayout(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.RightEyePanel = new OandB_coords(0, 0, n, n2 / 2 - 22);
        this.LeftEyePanel = new OandB_coords(0, n2 / 2 + 22, n, n2 / 2 - 22);
    }

    public OandB_coords getLeftPanelCoords() {
        return this.LeftEyePanel;
    }

    public OandB_coords getRightPanelCoords() {
        return this.RightEyePanel;
    }

    public void addLayoutComponent(Component component, Object object) {
        if (object instanceof OandB_coords) {
            this.info.put(component, object);
        }
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
        this.info.remove(component);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.getLayoutSize(container, true);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.getLayoutSize(container, false);
    }

    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int n = container.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            Component component = container.getComponent(n2);
            if (component.isVisible()) {
                Rectangle rectangle = this.getComponentBounds(component, true);
                component.setBounds(insets.left + rectangle.x, insets.top + rectangle.y, rectangle.width, rectangle.height);
            }
            ++n2;
        }
    }

    private Rectangle getComponentBounds(Component component, boolean bl) {
        OandB_coords oandB_coords = (OandB_coords)this.info.get(component);
        if (oandB_coords == null) {
            oandB_coords = new OandB_coords(0, 0, 0, 0);
        }
        Rectangle rectangle = new Rectangle(oandB_coords.getX(), oandB_coords.getY(), oandB_coords.getWidth(), oandB_coords.getHeight());
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            Dimension dimension;
            Dimension dimension2 = dimension = bl ? component.getPreferredSize() : component.getMinimumSize();
            if (rectangle.width <= 0) {
                rectangle.width = dimension.width;
            }
            if (rectangle.height <= 0) {
                rectangle.height = dimension.height;
            }
        }
        return rectangle;
    }

    private Dimension getLayoutSize(Container container, boolean bl) {
        Dimension dimension = new Dimension(0, 0);
        if (this.width <= 0 || this.height <= 0) {
            int n = container.getComponentCount();
            int n2 = 0;
            while (n2 < n) {
                Component component = container.getComponent(n2);
                if (component.isVisible()) {
                    Rectangle rectangle = this.getComponentBounds(component, bl);
                    dimension.width = Math.max(dimension.width, rectangle.x + rectangle.width);
                    dimension.height = Math.max(dimension.height, rectangle.y + rectangle.height);
                }
                ++n2;
            }
        }
        if (this.width > 0) {
            dimension.width = this.width;
        }
        if (this.height > 0) {
            dimension.height = this.height;
        }
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    class OandB_coords {
        private int x;
        private int y;
        private int width;
        private int height;

        OandB_coords(int n, int n2, int n3, int n4) {
            this.x = n;
            this.y = n2;
            this.width = n3;
            this.height = n4;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

