/*
 * Decompiled with CFR 0.152.
 */
package jwsu.utils.LatheShapes;

import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import java.text.DecimalFormat;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.Material;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.TexCoord2f;
import jwsu.utils.LatheShapes.LatheCurve;

public class LatheShape3D
extends Shape3D {
    private static final double RADS_DEGREE = Math.PI / 180;
    private static final double ANGLE_INCR = 15.0;
    private static final int NUM_SLICES = 24;
    private static final Color3f pink = new Color3f(1.0f, 0.75f, 0.8f);
    private static final Color3f darkPink = new Color3f(0.25f, 0.18f, 0.2f);
    private static final Color3f black = new Color3f(0.0f, 0.0f, 0.0f);
    private double height;

    public LatheShape3D(double[] dArray, double[] dArray2, Texture texture) {
        LatheCurve latheCurve = new LatheCurve(dArray, dArray2);
        this.buildShape(latheCurve.getXs(), latheCurve.getYs(), latheCurve.getHeight(), texture);
    }

    public LatheShape3D(double[] dArray, double[] dArray2, Color3f color3f, Color3f color3f2) {
        LatheCurve latheCurve = new LatheCurve(dArray, dArray2);
        this.buildShape(latheCurve.getXs(), latheCurve.getYs(), latheCurve.getHeight(), color3f, color3f2);
    }

    private void buildShape(double[] dArray, double[] dArray2, double d) {
        this.height = d;
        this.createGeometry(dArray, dArray2, false);
        this.createAppearance(darkPink, pink);
    }

    private void buildShape(double[] dArray, double[] dArray2, double d, Color3f color3f, Color3f color3f2) {
        this.height = d;
        this.createGeometry(dArray, dArray2, false);
        if (color3f == null || color3f2 == null) {
            System.out.println("One of the colours is null; using defaults");
            this.createAppearance(darkPink, pink);
        } else {
            this.createAppearance(color3f, color3f2);
        }
    }

    private void buildShape(double[] dArray, double[] dArray2, double d, Texture texture) {
        this.height = d;
        if (texture == null) {
            this.createGeometry(dArray, dArray2, false);
            this.createAppearance(darkPink, pink);
        } else {
            this.createGeometry(dArray, dArray2, true);
            this.createAppearance(texture);
        }
    }

    private void createGeometry(double[] dArray, double[] dArray2, boolean bl) {
        TexCoord2f[] texCoord2fArray;
        double[] dArray3 = this.surfaceRevolve(dArray, dArray2);
        GeometryInfo geometryInfo = new GeometryInfo(2);
        geometryInfo.setCoordinates(dArray3);
        if (bl) {
            geometryInfo.setTextureCoordinateParams(1, 2);
            texCoord2fArray = this.initTexCoords(dArray3);
            this.correctTexCoords(texCoord2fArray);
            geometryInfo.setTextureCoordinates(0, texCoord2fArray);
        }
        texCoord2fArray = new NormalGenerator();
        texCoord2fArray.generateNormals(geometryInfo);
        this.setGeometry((Geometry)geometryInfo.getGeometryArray());
    }

    private void printVerts(double[] dArray) {
        DecimalFormat decimalFormat = new DecimalFormat("0.###");
        int n = 6;
        int n2 = 0;
        System.out.println("No. vertices: " + dArray.length + "\n");
        int n3 = 0;
        while (n3 < dArray.length) {
            if (n2 == n) {
                System.out.println();
                n2 = 0;
            }
            System.out.print("(" + decimalFormat.format(dArray[n3]) + ", " + decimalFormat.format(dArray[n3 + 1]) + ", " + decimalFormat.format(dArray[n3 + 2]) + ")  ");
            n2 += 3;
            n3 += 3;
        }
        System.out.println("\n");
    }

    private TexCoord2f[] initTexCoords(double[] dArray) {
        int n = dArray.length;
        TexCoord2f[] texCoord2fArray = new TexCoord2f[n / 3];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n / 3) {
            double d = dArray[n2];
            double d2 = dArray[n2 + 1];
            double d3 = dArray[n2 + 2];
            double d4 = Math.atan2(d, d3);
            double d5 = d4 / Math.PI;
            float f = (float)(0.5 + d5 / 2.0);
            float f2 = (float)(d2 / this.height);
            texCoord2fArray[n3] = new TexCoord2f(f, f2);
            n2 += 3;
            ++n3;
        }
        return texCoord2fArray;
    }

    private void printTexCoords(TexCoord2f[] texCoord2fArray) {
        System.out.println("No. tex coords: " + texCoord2fArray.length + "\n");
        int n = 0;
        while (n < texCoord2fArray.length) {
            System.out.println(texCoord2fArray[n] + "  " + texCoord2fArray[n + 1]);
            n += 2;
        }
        System.out.println("\n");
    }

    private void correctTexCoords(TexCoord2f[] texCoord2fArray) {
        int n = 0;
        while (n < texCoord2fArray.length) {
            if (texCoord2fArray[n].x < texCoord2fArray[n + 3].x && texCoord2fArray[n + 1].x < texCoord2fArray[n + 2].x) {
                texCoord2fArray[n].x = (1.0f + texCoord2fArray[n + 3].x) / 2.0f;
                texCoord2fArray[n + 1].x = (1.0f + texCoord2fArray[n + 2].x) / 2.0f;
            }
            n += 4;
        }
    }

    private void createAppearance(Color3f color3f, Color3f color3f2) {
        Appearance appearance = new Appearance();
        PolygonAttributes polygonAttributes = new PolygonAttributes();
        polygonAttributes.setCullFace(0);
        appearance.setPolygonAttributes(polygonAttributes);
        Material material = new Material(color3f, black, color3f2, black, 1.0f);
        material.setLightingEnable(true);
        appearance.setMaterial(material);
        this.setAppearance(appearance);
    }

    private void createAppearance(Texture texture) {
        Appearance appearance = new Appearance();
        PolygonAttributes polygonAttributes = new PolygonAttributes();
        polygonAttributes.setCullFace(0);
        appearance.setPolygonAttributes(polygonAttributes);
        TextureAttributes textureAttributes = new TextureAttributes();
        textureAttributes.setTextureMode(2);
        appearance.setTextureAttributes(textureAttributes);
        Material material = new Material();
        material.setSpecularColor(black);
        material.setLightingEnable(true);
        appearance.setMaterial(material);
        appearance.setTexture(texture);
        this.setAppearance(appearance);
    }

    private double[] surfaceRevolve(double[] dArray, double[] dArray2) {
        this.checkCoords(dArray);
        double[] dArray3 = new double[24 * (dArray.length - 1) * 4 * 3];
        int n = 0;
        int n2 = 0;
        while (n2 < dArray.length - 1) {
            int n3 = 0;
            while (n3 < 24) {
                this.addCorner(dArray3, dArray[n2], dArray2[n2], n3, n);
                this.addCorner(dArray3, dArray[n2 + 1], dArray2[n2 + 1], n3, n += 3);
                this.addCorner(dArray3, dArray[n2 + 1], dArray2[n2 + 1], n3 + 1, n += 3);
                this.addCorner(dArray3, dArray[n2], dArray2[n2], n3 + 1, n += 3);
                n += 3;
                ++n3;
            }
            ++n2;
        }
        return dArray3;
    }

    private void checkCoords(double[] dArray) {
        int n = 0;
        while (n < dArray.length) {
            if (dArray[n] < 0.0) {
                System.out.println("Warning: setting xs[" + n + "] from -ve to 0");
                dArray[n] = 0.0;
            }
            ++n;
        }
    }

    private void addCorner(double[] dArray, double d, double d2, int n, int n2) {
        double d3 = Math.PI / 180 * ((double)n * 15.0);
        dArray[n2] = n == 24 ? d : this.xCoord(d, d3);
        dArray[n2 + 1] = d2;
        dArray[n2 + 2] = n == 24 ? 0.0 : this.zCoord(d, d3);
    }

    protected double xCoord(double d, double d2) {
        return d * Math.cos(d2);
    }

    protected double zCoord(double d, double d2) {
        return d * Math.sin(d2);
    }
}

