/*
 * Decompiled with CFR 0.152.
 */
package jwsu.utils.LatheShapes;

import javax.vecmath.Point2d;

class LatheCurve {
    private static final int STEP = 5;
    double[] xs;
    double[] ys;
    double height;

    LatheCurve(double[] dArray, double[] dArray2) {
        this.checkLength(dArray, dArray2);
        this.checkYs(dArray2);
        int n = dArray.length;
        Point2d point2d = new Point2d((Math.abs(dArray[1]) - Math.abs(dArray[0])) * 2.0, 0.0);
        Point2d point2d2 = new Point2d((Math.abs(dArray[n - 1]) - Math.abs(dArray[n - 2])) * 2.0, 0.0);
        this.makeCurve(dArray, dArray2, point2d, point2d2);
    }

    LatheCurve(double[] dArray, double[] dArray2, Point2d point2d, Point2d point2d2) {
        this.checkLength(dArray, dArray2);
        this.checkYs(dArray2);
        this.checkTangent(point2d);
        this.checkTangent(point2d2);
        this.makeCurve(dArray, dArray2, point2d, point2d2);
    }

    private void checkLength(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        if (n < 2) {
            System.out.println("Not enough points to make a curve");
            System.exit(0);
        } else if (n != dArray2.length) {
            System.out.println("xsIn[] and ysIn[] do not have the same number of points");
            System.exit(0);
        }
    }

    private void checkYs(double[] dArray) {
        if (dArray[0] != 0.0) {
            System.out.println("The first y-coordinate must be 0; correcting it");
            dArray[0] = 0.0;
        }
        this.height = dArray[0];
        int n = 1;
        while (n < dArray.length) {
            if (dArray[n] >= this.height) {
                this.height = dArray[n];
            }
            if (dArray[n] < 0.0) {
                System.out.println("Found a negative y-coord; changing it to be 0");
                dArray[n] = 0.0;
            }
            ++n;
        }
    }

    private void checkTangent(Point2d point2d) {
        if (point2d.x == 0.0 && point2d.y == 0.0) {
            System.out.println("A tangent cannot be (0,0)");
            System.exit(0);
        }
    }

    private void makeCurve(double[] dArray, double[] dArray2, Point2d point2d, Point2d point2d2) {
        int n = dArray.length;
        int n2 = this.countVerts(dArray, n);
        this.xs = new double[n2];
        this.ys = new double[n2];
        this.xs[0] = Math.abs(dArray[0]);
        this.ys[0] = dArray2[0];
        int n3 = 1;
        Point2d point2d3 = new Point2d();
        Point2d point2d4 = new Point2d();
        int n4 = 0;
        while (n4 < n - 1) {
            if (n4 == 0) {
                point2d3.set(point2d.x, point2d.y);
            } else {
                point2d3.set(point2d4.x, point2d4.y);
            }
            if (n4 == n - 2) {
                point2d4.set(point2d2.x, point2d2.y);
            } else {
                this.setTangent(point2d4, dArray, dArray2, n4 + 1);
            }
            if (dArray[n4] < 0.0) {
                this.xs[n3] = Math.abs(dArray[n4 + 1]);
                this.ys[n3] = dArray2[n4 + 1];
                ++n3;
            } else {
                this.makeHermite(this.xs, this.ys, n3, dArray[n4], dArray2[n4], dArray[n4 + 1], dArray2[n4 + 1], point2d3, point2d4);
                n3 += 6;
            }
            ++n4;
        }
    }

    private int countVerts(double[] dArray, int n) {
        int n2 = 1;
        int n3 = 0;
        while (n3 < n - 1) {
            n2 = dArray[n3] < 0.0 ? ++n2 : (n2 += 6);
            ++n3;
        }
        return n2;
    }

    private void setTangent(Point2d point2d, double[] dArray, double[] dArray2, int n) {
        double d = Math.abs(dArray[n + 1]) - Math.abs(dArray[n - 1]);
        double d2 = dArray2[n + 1] - dArray2[n - 1];
        point2d.set(d / 2.0, d2 / 2.0);
    }

    private void makeHermite(double[] dArray, double[] dArray2, int n, double d, double d2, double d3, double d4, Point2d point2d, Point2d point2d2) {
        double d5 = 0.16666666666666666;
        if (d3 < 0.0) {
            d3 = -d3;
        }
        int n2 = 0;
        while (n2 < 5) {
            double d6;
            double d7;
            double d8 = d5 * (double)(n2 + 1);
            dArray[n + n2] = d7 = this.fh1(d8) * d + this.fh2(d8) * d3 + this.fh3(d8) * point2d.x + this.fh4(d8) * point2d2.x;
            dArray2[n + n2] = d6 = this.fh1(d8) * d2 + this.fh2(d8) * d4 + this.fh3(d8) * point2d.y + this.fh4(d8) * point2d2.y;
            ++n2;
        }
        dArray[n + 5] = d3;
        dArray2[n + 5] = d4;
    }

    private double fh1(double d) {
        return 2.0 * Math.pow(d, 3.0) - 3.0 * d * d + 1.0;
    }

    private double fh2(double d) {
        return -2.0 * Math.pow(d, 3.0) + 3.0 * d * d;
    }

    private double fh3(double d) {
        return Math.pow(d, 3.0) - 2.0 * d * d + d;
    }

    private double fh4(double d) {
        return Math.pow(d, 3.0) - d * d;
    }

    double[] getXs() {
        return this.xs;
    }

    double[] getYs() {
        return this.ys;
    }

    double getHeight() {
        return this.height;
    }
}

