/*
 * Decompiled with CFR 0.152.
 */
package jwsu.loaders.STL;

import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URL;
import jwsu.loaders.STL.STLASCIIParser;
import jwsu.loaders.STL.STLBinaryParser;
import jwsu.loaders.STL.STLParser;

class STLFileReader {
    private STLParser itsParser;

    public STLFileReader(File file) throws InterruptedIOException, IOException, FileNotFoundException {
        this(file.toURL());
    }

    public STLFileReader(String string) throws InterruptedIOException, IOException, FileNotFoundException {
        this(new URL(string));
    }

    public STLFileReader(URL uRL) throws IOException, FileNotFoundException {
        STLASCIIParser sTLASCIIParser = new STLASCIIParser();
        if (sTLASCIIParser.parse(uRL)) {
            this.itsParser = sTLASCIIParser;
        } else {
            STLBinaryParser sTLBinaryParser = new STLBinaryParser();
            sTLBinaryParser.parse(uRL);
            this.itsParser = sTLBinaryParser;
        }
    }

    public STLFileReader(URL uRL, Component component) throws InterruptedIOException, IOException, FileNotFoundException {
        STLASCIIParser sTLASCIIParser = new STLASCIIParser();
        if (sTLASCIIParser.parse(uRL, component)) {
            this.itsParser = sTLASCIIParser;
        } else {
            STLBinaryParser sTLBinaryParser = new STLBinaryParser();
            sTLBinaryParser.parse(uRL, component);
            this.itsParser = sTLBinaryParser;
        }
    }

    public STLFileReader(File file, Component component) throws InterruptedIOException, IOException, FileNotFoundException {
        this(file.toURL(), component);
    }

    public STLFileReader(String string, Component component) throws InterruptedIOException, IOException, FileNotFoundException {
        this(new URL(string), component);
    }

    public boolean getNextFacet(double[] dArray, double[][] dArray2) throws InterruptedIOException, IOException {
        return this.itsParser.getNextFacet(dArray, dArray2);
    }

    public String[] getObjectNames() {
        return this.itsParser.getObjectNames();
    }

    public int[] getNumOfFacets() {
        return this.itsParser.getNumOfFacets();
    }

    public int getNumOfObjects() {
        return this.itsParser.getNumOfObjects();
    }

    public void close() throws IOException {
        if (this.itsParser != null) {
            this.itsParser.close();
        }
    }
}

