/*
 * Decompiled with CFR 0.152.
 */
package jwsu.loaders.STL;

import java.io.IOException;
import java.io.InputStream;

class LittleEndianConverter {
    LittleEndianConverter() {
    }

    public static void main(String[] stringArray) {
        LittleEndianConverter.test();
    }

    public static int convertToBigEndian(byte[] byArray, short[] sArray, int n, int n2, int n3) {
        return LittleEndianConverter.convertToBigEndian(byArray, sArray, n, n2, n3, (short)255);
    }

    public static int convertToBigEndian(byte[] byArray, short[] sArray, int n, int n2, int n3, short s) {
        int n4 = Math.min(n3 * 2, n / 2 * 2);
        int n5 = 0;
        while (n5 < n4) {
            int n6 = (byArray[n5] & 0xFF | byArray[n5 + 1] << 8) & s;
            sArray[n5 / 2 + n2] = (short)n6;
            n5 += 2;
        }
        return n4;
    }

    public static int convertToBigEndian(byte[] byArray, int[] nArray, int n, int n2, int n3) {
        return LittleEndianConverter.convertToBigEndian(byArray, nArray, n, n2, n3, -1);
    }

    public static int convertToBigEndian(byte[] byArray, int[] nArray, int n, int n2, int n3, int n4) {
        int n5 = Math.min(n3 * 4, n / 4 * 4);
        int n6 = 0;
        while (n6 < n5) {
            nArray[n6 / 4 + n2] = (byArray[n6] & 0xFF | byArray[n6 + 1] << 8 & 0xFF00 | byArray[n6 + 2] << 16 & 0xFF0000 | byArray[n6 + 3] << 24) & n4;
            n6 += 4;
        }
        return n5;
    }

    public static int convertToBigEndian(int n, byte[] byArray, int[] nArray, int n2, int n3, int n4) {
        return LittleEndianConverter.convertToBigEndian(n, byArray, nArray, n2, n3, n4, -1);
    }

    public static int convertToBigEndian(int n, byte[] byArray, int[] nArray, int n2, int n3, int n4, int n5) {
        int n6 = Math.min(n4 * n, n2 / n * n);
        if (n == 2) {
            int n7 = 0;
            while (n7 < n6) {
                nArray[n7 / 2 + n3] = (byArray[n7] & 0xFF | byArray[n7 + 1] << 8) & n5;
                n7 += 2;
            }
            return n6;
        }
        if (n == 3) {
            int n8 = 0;
            while (n8 < n6) {
                nArray[n8 / 3 + n3] = (byArray[n8] & 0xFF | byArray[n8 + 1] << 8 & 0xFF00 | byArray[n8 + 2] << 24) & n5;
                n8 += 3;
            }
            return n6;
        }
        if (n == 4) {
            return LittleEndianConverter.convertToBigEndian(byArray, nArray, n2, n3, n4, n5);
        }
        return 0;
    }

    public static int read(byte[] byArray, short[] sArray, int n, int n2, InputStream inputStream) throws IOException {
        return LittleEndianConverter.read(byArray, sArray, n, n2, inputStream, (short)255);
    }

    public static int read(byte[] byArray, short[] sArray, int n, int n2, InputStream inputStream, short s) throws IOException {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = byArray.length / 2 * 2;
        while (n3 >= 0 && n4 < n2) {
            int n7;
            int n8 = Math.min((n2 - n4) * 2, n6);
            n3 = inputStream.read(byArray, n5, n8 - n5);
            if (n3 - (n7 = LittleEndianConverter.convertToBigEndian(byArray, sArray, n3 + n5, n + n4, n2 - n4, s)) == 1) {
                n5 = 1;
                byArray[0] = byArray[n7];
            } else {
                n5 = 0;
            }
            n4 += n7 / 2;
        }
        return n4;
    }

    public static int read(byte[] byArray, int[] nArray, int n, int n2, InputStream inputStream) throws IOException {
        return LittleEndianConverter.read(byArray, nArray, n, n2, inputStream, -1);
    }

    public static int read(byte[] byArray, int[] nArray, int n, int n2, InputStream inputStream, int n3) throws IOException {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = byArray.length / 4 * 4;
        while (n4 >= 0 && n5 < n2) {
            int n8 = Math.min((n2 - n5) * 4, n7);
            n4 = inputStream.read(byArray, n6, n8 - n6);
            int n9 = LittleEndianConverter.convertToBigEndian(byArray, nArray, n4 + n6, n + n5, n2 - n5, n3);
            int n10 = n4 - n9;
            n6 = 0;
            if (n10 == 1) {
                n6 = 1;
                byArray[0] = byArray[n9];
            }
            if (n10 == 2) {
                n6 = 2;
                byArray[1] = byArray[n9 + 1];
            }
            if (n10 == 3) {
                n6 = 3;
                byArray[2] = byArray[n9 + 2];
            }
            n5 += n9 / 4;
        }
        return n5;
    }

    public static int read(int n, byte[] byArray, int[] nArray, int n2, int n3, InputStream inputStream) throws IOException {
        return LittleEndianConverter.read(n, byArray, nArray, n2, n3, inputStream, -1);
    }

    public static int read(int n, byte[] byArray, int[] nArray, int n2, int n3, InputStream inputStream, int n4) throws IOException {
        if (n == 2) {
            return LittleEndianConverter.read2ByteBlock(byArray, nArray, n2, n3, inputStream, n4);
        }
        if (n == 3) {
            return LittleEndianConverter.read3ByteBlock(byArray, nArray, n2, n3, inputStream, n4);
        }
        if (n == 4) {
            return LittleEndianConverter.read(byArray, nArray, n2, n3, inputStream, n4);
        }
        return 0;
    }

    public static int read4ByteBlock(InputStream inputStream) throws IOException {
        return LittleEndianConverter.read(inputStream) & 0xFF | LittleEndianConverter.read(inputStream) << 8 & 0xFF00 | LittleEndianConverter.read(inputStream) << 16 & 0xFF0000 | LittleEndianConverter.read(inputStream) << 24;
    }

    public static int read2ByteBlock(InputStream inputStream) throws IOException {
        return LittleEndianConverter.read(inputStream) & 0xFF | LittleEndianConverter.read(inputStream) << 8;
    }

    public static int read3ByteBlock(InputStream inputStream) throws IOException {
        return LittleEndianConverter.read(inputStream) & 0xFF | LittleEndianConverter.read(inputStream) << 8 & 0xFF00 | LittleEndianConverter.read(inputStream) << 16;
    }

    private static int read2ByteBlock(byte[] byArray, int[] nArray, int n, int n2, InputStream inputStream, int n3) throws IOException {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = byArray.length / 2 * 2;
        while (n4 >= 0 && n5 < n2) {
            int n8;
            int n9 = Math.max((n2 - n5) * 2, n7);
            n4 = inputStream.read(byArray, n6, n9 - n6);
            if (n4 - (n8 = LittleEndianConverter.convertToBigEndian(2, byArray, nArray, n4 + n6, n + n5, n2 - n5, n3)) == 1) {
                n6 = 1;
                byArray[0] = byArray[n8];
            } else {
                n6 = 0;
            }
            n5 += n8 / 2;
        }
        return n5;
    }

    private static int read3ByteBlock(byte[] byArray, int[] nArray, int n, int n2, InputStream inputStream, int n3) throws IOException {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = byArray.length / 3 * 3;
        while (n4 >= 0 && n5 < n2) {
            int n8 = Math.max((n2 - n5) * 3, n7);
            n4 = inputStream.read(byArray, n6, n8 - n6);
            int n9 = LittleEndianConverter.convertToBigEndian(3, byArray, nArray, n4 + n6, n + n5, n2 - n5, n3);
            int n10 = n4 - n9;
            n6 = 0;
            if (n10 == 1) {
                n6 = 1;
                byArray[0] = byArray[n9];
            }
            if (n10 == 2) {
                n6 = 2;
                byArray[1] = byArray[n9 + 1];
            }
            n5 += n9 / 3;
        }
        return n5;
    }

    private static int read(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == -1) {
            throw new IOException("Filesize does not match blocksize");
        }
        return n;
    }

    private static void test() {
        byte[] byArray = new byte[]{0, 0, 0, -1, -1, 0, -1, -1, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, -1, 0, 0, -1, 0, 0, -1, 0, 0, 0, -1, 0, 0, -1, 0, -1, -1, 0, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, -1, -1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 1, 1, 0, 1, 1, 1, 1};
        short[] sArray = new short[byArray.length / 2];
        int[] nArray = new int[byArray.length / 4];
        LittleEndianConverter.convertToBigEndian(byArray, sArray, byArray.length, 0, sArray.length);
        LittleEndianConverter.convertToBigEndian(byArray, nArray, byArray.length, 0, nArray.length);
        System.out.println("Source");
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (n2 % 4 == 0 && n2 != 0) {
                System.out.println();
            }
            System.out.print(Integer.toHexString(byArray[n2] & 0xFF) + " ");
            ++n2;
        }
        System.out.println();
        System.out.println("Short");
        n = sArray.length;
        int n3 = 0;
        while (n3 < n) {
            System.out.print(Integer.toHexString(sArray[n3] & 0xFFFF) + " ");
            ++n3;
        }
        System.out.println();
        System.out.println("int blockSize 4");
        n = nArray.length;
        int n4 = 0;
        while (n4 < n) {
            System.out.print(Integer.toHexString(nArray[n4]) + " ");
            ++n4;
        }
        System.out.println();
    }
}

