/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.CColor;
import controlP5.ControlBroadcaster;
import controlP5.ControlFont;
import controlP5.ControlListener;
import controlP5.ControlP5Base;
import controlP5.ControlP5IOHandler;
import controlP5.ControlWindow;
import controlP5.ControlWindowKeyHandler;
import controlP5.ControlWindowKeyListener;
import controlP5.Controller;
import controlP5.ControllerGroup;
import controlP5.ControllerInterface;
import controlP5.Tab;
import controlP5.Textfield;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import processing.core.PApplet;
import processing.core.PFont;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlP5
extends ControlP5Base {
    public ControlWindow controlWindow;
    private Hashtable<String, ControllerInterface> _myControllerMap;
    protected ControlBroadcaster _myControlBroadcaster;
    private String _myUrlPath = "";
    private String _myFilePath = "controlP5.xml";
    public CColor color = new CColor();
    protected Vector<ControlWindow> controlWindowList;
    protected static boolean isMoveable = false;
    protected boolean isAutoInitialization = false;
    protected boolean isGlobalControllersAlwaysVisible = true;
    public static final int standard58 = 0;
    public static final int standard56 = 1;
    public static final int synt24 = 2;
    public static final int grixel = 3;
    public static ControlWindowKeyHandler keyHandler;
    public static PApplet papplet;
    public static final String VERSION = "0.5.4";
    public static boolean isApplet;
    public static boolean DEBUG;
    protected ControlP5IOHandler _myControlP5IOHandler;
    protected boolean isTabEventsActive;
    protected boolean isUpdate;
    protected static boolean isControlFont;
    protected static ControlFont controlFont;
    protected boolean isShortcuts = true;
    protected boolean blockDraw;
    private static final Logger logger;

    public ControlP5(PApplet pApplet) {
        papplet = pApplet;
        papplet = pApplet;
        this.init();
    }

    public ControlP5(PApplet pApplet, ControlFont controlFont) {
        papplet = pApplet;
        this.setControlFont(controlFont);
        this.init();
    }

    protected void init() {
        this.welcome();
        this.isTabEventsActive = false;
        this._myControlP5IOHandler = new ControlP5IOHandler(this);
        this.controlWindowList = new Vector();
        this._myControlBroadcaster = new ControlBroadcaster(this);
        keyHandler = new ControlWindowKeyHandler(this);
        this.controlWindow = new ControlWindow(this, papplet);
        papplet.registerKeyEvent((Object)new ControlWindowKeyListener(this));
        papplet.registerDispose((Object)this);
        this._myControllerMap = new Hashtable();
        this.controlWindowList.add(this.controlWindow);
        isApplet = ControlP5.papplet.online;
        super.init(this);
    }

    private void welcome() {
        System.out.println("ControlP5 0.5.4 infos, comments, questions at http://www.sojamo.de/libraries/controlP5");
    }

    public void setTabEventsActive(boolean bl) {
        this.isTabEventsActive = bl;
    }

    public void setAutoInitialization(boolean bl) {
        this.isAutoInitialization = bl;
    }

    public void setAutoDraw(boolean bl) {
        if (this.isAutoDraw() && !bl) {
            this.controlWindow.papplet().unregisterDraw((Object)this.controlWindow);
        }
        if (!this.isAutoDraw() && bl) {
            this.controlWindow.papplet().registerDraw((Object)this.controlWindow);
        }
        this.controlWindow.isAutoDraw = bl;
    }

    public boolean isAutoDraw() {
        return this.controlWindow.isAutoDraw;
    }

    public ControlBroadcaster controlbroadcaster() {
        return this._myControlBroadcaster;
    }

    public void addListener(ControlListener controlListener) {
        this.controlbroadcaster().addListener(controlListener);
    }

    public void removeListener(ControlListener controlListener) {
        this.controlbroadcaster().removeListener(controlListener);
    }

    public ControlListener getListener(int n) {
        return this.controlbroadcaster().getListener(n);
    }

    public Tab tab(String string) {
        return this.getTab(string);
    }

    public Tab getTab(String string) {
        for (int i = 0; i < this.controlWindowList.size(); ++i) {
            for (int j = 0; j < this.controlWindowList.get(i).tabs().size(); ++j) {
                if (!((Tab)this.controlWindowList.get(i).tabs().get(j)).name().equals(string)) continue;
                return (Tab)this.controlWindowList.get(i).tabs().get(j);
            }
        }
        Tab tab = this.addTab(string);
        return tab;
    }

    public Tab tab(ControlWindow controlWindow, String string) {
        return this.getTab(controlWindow, string);
    }

    public Tab getTab(ControlWindow controlWindow, String string) {
        for (int i = 0; i < controlWindow.tabs().size(); ++i) {
            if (!((Tab)controlWindow.tabs().get(i)).name().equals(string)) continue;
            return (Tab)controlWindow.tabs().get(i);
        }
        Tab tab = controlWindow.add(new Tab(this, controlWindow, string));
        return tab;
    }

    public void register(ControllerInterface controllerInterface) {
        this.checkName(controllerInterface.name());
        this._myControllerMap.put(controllerInterface.name(), controllerInterface);
        controllerInterface.init();
    }

    public ControllerInterface[] getControllerList() {
        ControllerInterface[] controllerInterfaceArray = new ControllerInterface[this._myControllerMap.size()];
        this._myControllerMap.values().toArray(controllerInterfaceArray);
        return controllerInterfaceArray;
    }

    protected void deactivateControllers() {
        if (this.getControllerList() != null) {
            ControllerInterface[] controllerInterfaceArray = this.getControllerList();
            for (int i = 0; i < controllerInterfaceArray.length; ++i) {
                if (!(controllerInterfaceArray[i] instanceof Textfield)) continue;
                ((Textfield)controllerInterfaceArray[i]).setFocus(false);
            }
        }
    }

    protected void clear() {
        int n;
        for (n = this.controlWindowList.size() - 1; n >= 0; --n) {
            this.controlWindowList.get(n).clear();
        }
        for (n = this.controlWindowList.size() - 1; n >= 0; --n) {
            this.controlWindowList.remove(n);
        }
        this._myControllerMap.clear();
    }

    protected void remove(ControlWindow controlWindow) {
        controlWindow.remove();
        this.controlWindowList.remove(controlWindow);
    }

    protected void remove(ControllerInterface controllerInterface) {
        this._myControllerMap.remove(controllerInterface.name());
    }

    public void remove(String string) {
        if (this.controller(string) != null) {
            this.controller(string).remove();
        }
        if (this.group(string) != null) {
            this.group(string).remove();
        }
        for (int i = 0; i < this.controlWindowList.size(); ++i) {
            for (int j = 0; j < this.controlWindowList.get(i).tabs().size(); ++j) {
                if (!((Tab)this.controlWindowList.get(i).tabs().get(j)).name().equals(string)) continue;
                ((Tab)this.controlWindowList.get(i).tabs().get(j)).remove();
            }
        }
    }

    public Controller controller(String string) {
        if (this._myControllerMap.containsKey(string) && this._myControllerMap.get(string) instanceof Controller) {
            return (Controller)this._myControllerMap.get(string);
        }
        return null;
    }

    public ControllerGroup group(String string) {
        return this.getGroup(string);
    }

    public ControllerGroup getGroup(String string) {
        if (this._myControllerMap.containsKey(string) && this._myControllerMap.get(string) instanceof ControllerGroup) {
            return (ControllerGroup)this._myControllerMap.get(string);
        }
        return null;
    }

    public void draw() {
        if (!this.blockDraw) {
            this.controlWindow.draw();
        }
    }

    public ControlWindow window(PApplet pApplet) {
        if (pApplet.equals(papplet)) {
            return this.controlWindow;
        }
        return this.controlWindow;
    }

    public ControlWindow window(String string) {
        for (int i = 0; i < this.controlWindowList.size(); ++i) {
            if (!this.controlWindowList.get(i).name().equals(string)) continue;
            return this.controlWindowList.get(i);
        }
        ControlP5.logger().warning("ControlWindow " + string + " does not exist. returning null.");
        return null;
    }

    private boolean checkName(String string) {
        if (this._myControllerMap.containsKey(string)) {
            ControlP5.logger().warning("Controller with name \"" + string + "\" already exists. overwriting reference of existing controller.");
            return true;
        }
        return false;
    }

    public void setFilePath(String string) {
        if (string == null) {
            string = "";
        }
        this._myFilePath = string;
    }

    public void setUrlPath(String string) {
        this.setUrlPath(string, "controlP5.xml");
    }

    public void setUrlPath(String string, String string2) {
        if (string == null) {
            string = "";
            return;
        }
        if ((string = ControlP5IOHandler.replace(string, "&amp;", "&")).indexOf(63) == -1) {
            string = string + '?';
        } else if (!string.endsWith("&") && !string.endsWith("?")) {
            string = string + "&";
        }
        this._myUrlPath = string + "filename=" + string2;
    }

    public String filePath() {
        return this._myFilePath;
    }

    public String urlPath() {
        return this._myUrlPath;
    }

    public void setColorActive(int n) {
        this.color.colorActive = n;
        Enumeration<ControlWindow> enumeration = this.controlWindowList.elements();
        while (enumeration.hasMoreElements()) {
            ControlWindow controlWindow = enumeration.nextElement();
            controlWindow.setColorActive(n);
        }
    }

    public void setColorForeground(int n) {
        this.color.colorForeground = n;
        Enumeration<ControlWindow> enumeration = this.controlWindowList.elements();
        while (enumeration.hasMoreElements()) {
            ControlWindow controlWindow = enumeration.nextElement();
            controlWindow.setColorForeground(n);
        }
    }

    public void setColorBackground(int n) {
        this.color.colorBackground = n;
        Enumeration<ControlWindow> enumeration = this.controlWindowList.elements();
        while (enumeration.hasMoreElements()) {
            ControlWindow controlWindow = enumeration.nextElement();
            controlWindow.setColorBackground(n);
        }
    }

    public void setColorLabel(int n) {
        this.color.colorCaptionLabel = n;
        Enumeration<ControlWindow> enumeration = this.controlWindowList.elements();
        while (enumeration.hasMoreElements()) {
            ControlWindow controlWindow = enumeration.nextElement();
            controlWindow.setColorLabel(n);
        }
    }

    public void setColorValue(int n) {
        this.color.colorValueLabel = n;
        Enumeration<ControlWindow> enumeration = this.controlWindowList.elements();
        while (enumeration.hasMoreElements()) {
            ControlWindow controlWindow = enumeration.nextElement();
            controlWindow.setColorValue(n);
        }
    }

    protected Vector<ControlWindow> controlWindows() {
        return this.controlWindowList;
    }

    public void setMoveable(boolean bl) {
        isMoveable = true;
    }

    public void isMoveable() {
        isMoveable = false;
    }

    public void lock() {
        isMoveable = false;
    }

    public void unlock() {
        isMoveable = true;
    }

    public boolean save(String string) {
        return this._myControlP5IOHandler.save(this, string);
    }

    public boolean save() {
        if (this._myFilePath != null) {
            return this._myControlP5IOHandler.save(this, this._myFilePath);
        }
        return false;
    }

    public boolean load(String string) {
        System.out.println("loading (1)");
        this.blockDraw = true;
        this.clear();
        ControlP5.logger().info("loading " + string);
        String[] stringArray = papplet.loadStrings(string);
        String string2 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = string2 + stringArray[i];
        }
        if (string2.length() == 0) {
            return false;
        }
        try {
            Thread.sleep(200L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._myControlP5IOHandler.parse(string2);
        this.blockDraw = false;
        return true;
    }

    public String version() {
        return VERSION;
    }

    public void show() {
        this.controlWindow.show();
    }

    public boolean isVisible() {
        return this.controlWindow.isVisible();
    }

    public void hide() {
        this.controlWindow.hide();
    }

    public void update() {
        Enumeration<ControlWindow> enumeration = this.controlWindowList.elements();
        while (enumeration.hasMoreElements()) {
            ControlWindow controlWindow = enumeration.nextElement();
            controlWindow.update();
        }
    }

    public boolean isUpdate() {
        return this.isUpdate;
    }

    public void setUpdate(boolean bl) {
        this.isUpdate = bl;
        Enumeration<ControlWindow> enumeration = this.controlWindowList.elements();
        while (enumeration.hasMoreElements()) {
            ControlWindow controlWindow = enumeration.nextElement();
            controlWindow.setUpdate(bl);
        }
    }

    public void trigger() {
        for (String string : this._myControllerMap.keySet()) {
            if (!(this._myControllerMap.get(string) instanceof Controller)) continue;
            ((Controller)this._myControllerMap.get(string)).trigger();
        }
    }

    public boolean setControlFont(ControlFont controlFont) {
        ControlP5.controlFont = controlFont;
        isControlFont = true;
        this.updateFont(ControlP5.controlFont);
        return isControlFont;
    }

    public boolean setControlFont(PFont pFont, int n) {
        controlFont = new ControlFont(pFont, n);
        isControlFont = true;
        this.updateFont(controlFont);
        return isControlFont;
    }

    public boolean setControlFont(PFont pFont) {
        controlFont = new ControlFont(pFont, pFont.findFont().getSize());
        isControlFont = true;
        this.updateFont(controlFont);
        return isControlFont;
    }

    protected void updateFont(ControlFont controlFont) {
        Enumeration<ControlWindow> enumeration = this.controlWindowList.elements();
        while (enumeration.hasMoreElements()) {
            ControlWindow controlWindow = enumeration.nextElement();
            controlWindow.updateFont(controlFont);
        }
    }

    public static ControlFont getControlFont() {
        return controlFont;
    }

    public void disableKeys() {
        this.isShortcuts = false;
    }

    public void enableKeys() {
        this.isShortcuts = true;
    }

    public void disableShortcuts() {
        this.isShortcuts = true;
    }

    public void enableShortcuts() {
        this.isShortcuts = false;
    }

    public ControllerGroup begin() {
        return this.begin(this.controlWindow.tab("default"));
    }

    public ControllerGroup begin(ControllerGroup controllerGroup) {
        this.setCurrentPointer(controllerGroup);
        return controllerGroup;
    }

    public ControllerGroup begin(int n, int n2) {
        return this.begin(this.controlWindow.tab("default"), n, n2);
    }

    public ControllerGroup begin(ControllerGroup controllerGroup, int n, int n2) {
        this.setCurrentPointer(controllerGroup);
        controllerGroup.autoPosition.x = n;
        controllerGroup.autoPosition.y = n2;
        controllerGroup.autoPositionOffsetX = n;
        return controllerGroup;
    }

    public ControllerGroup begin(ControlWindow controlWindow) {
        return this.begin(controlWindow.tab("default"));
    }

    public ControllerGroup begin(ControlWindow controlWindow, int n, int n2) {
        return this.begin(controlWindow.tab("default"), n, n2);
    }

    public ControllerGroup end(ControllerGroup controllerGroup) {
        this.releaseCurrentPointer(controllerGroup);
        return controllerGroup;
    }

    public ControllerGroup end() {
        return this.end(this.controlWindow.tab("default"));
    }

    public void dispose() {
        if (!isApplet) {
            this.clear();
        }
    }

    public static Logger logger() {
        return logger;
    }

    static {
        logger = Logger.getLogger("controlP5.ControlP5");
    }
}

